/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.api;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.FastClassAccessor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public final class ClassNodeHandle {
    private final byte @Nullable [] originalBytes;
    @Nullable
    private final ClassHeaderMetadata originalMetadata;
    private final int readerOptions;
    private boolean initialized = false;
    @Nullable
    private ClassNode node = null;
    @Nullable
    private FastClassAccessor accessor = null;
    private int writerFlags = 0;

    public ClassNodeHandle(byte @Nullable [] classData) {
        this(classData, 0);
    }

    public ClassNodeHandle(byte @Nullable [] classData, int readerOptions) {
        ClassHeaderMetadata originalMetadata;
        this.originalBytes = classData;
        if (classData == null) {
            originalMetadata = null;
        } else {
            try {
                originalMetadata = new ClassHeaderMetadata(classData);
            }
            catch (Exception e) {
                originalMetadata = null;
            }
        }
        this.originalMetadata = originalMetadata;
        this.accessor = originalMetadata;
        this.readerOptions = 0;
    }

    public byte @Nullable [] getOriginalBytes() {
        return this.originalBytes;
    }

    @Nullable
    public ClassHeaderMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    @Nullable
    public FastClassAccessor getFastAccessor() {
        return this.accessor;
    }

    public boolean isOriginal() {
        return !this.initialized;
    }

    public boolean isPresent() {
        if (this.initialized) {
            return this.node != null;
        }
        return this.originalBytes != null;
    }

    @Nullable
    public ClassNode getNode() {
        this.ensureInitialized();
        return this.node;
    }

    public void setNode(@Nullable ClassNode node) {
        this.initialized = true;
        this.node = node;
        this.accessor = node == null ? null : FastClassAccessor.ofAsmNode(node);
    }

    public byte @Nullable [] computeBytes() {
        if (!this.initialized) {
            return this.originalBytes;
        }
        if (this.node == null) {
            return null;
        }
        ClassWriter writer = new ClassWriter(this.writerFlags);
        this.node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public int getWriterFlags() {
        return this.writerFlags;
    }

    public void setWriterFlags(int flags) {
        this.writerFlags = flags;
    }

    public void orWriterFlags(int flags) {
        this.writerFlags |= flags;
    }

    public void computeMaxs() {
        this.writerFlags |= 1;
    }

    public void computeFrames() {
        this.writerFlags |= 2;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            if (this.originalBytes == null) {
                this.node = null;
                this.accessor = null;
            } else {
                this.node = new ClassNode();
                new ClassReader(this.originalBytes).accept((ClassVisitor)this.node, this.readerOptions);
                this.accessor = FastClassAccessor.ofAsmNode(this.node);
            }
            this.initialized = true;
        }
    }
}

