/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.asm.UpgradedTreeNodes;
import com.gtnewhorizons.retrofuturabootstrap.asm.UpgradedVisitors;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class AsmUpgradeTransformer
implements RfbClassTransformer {
    private static final byte[] quickScan = "org/objectweb/asm".getBytes(StandardCharsets.UTF_8);
    private final Map<String, String> upgradeMap = new HashMap<String, String>();

    public AsmUpgradeTransformer() {
        for (Class<?> visitor : UpgradedVisitors.ALL_VISITORS) {
            this.upgradeMap.put(Type.getInternalName(visitor.getSuperclass()), Type.getInternalName(visitor));
        }
        for (Class<?> visitor : UpgradedTreeNodes.ALL_NODES) {
            this.upgradeMap.put(Type.getInternalName(visitor.getSuperclass()), Type.getInternalName(visitor));
        }
    }

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "asm-upgrader";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (classNode.isOriginal()) {
            byte[] original = classNode.getOriginalBytes();
            return ClassHeaderMetadata.hasSubstring(original, quickScan);
        }
        return true;
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        String superclass;
        ClassNode node = classNode.getNode();
        if (node == null) {
            return;
        }
        if (node.superName != null && (superclass = this.upgradeMap.get(node.superName)) != null) {
            node.superName = superclass;
        }
        if (node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode rawInsn : method.instructions) {
                String upgraded;
                TypeInsnNode insn;
                if (rawInsn.getType() == 3 && rawInsn.getOpcode() == 187) {
                    insn = (TypeInsnNode)rawInsn;
                    upgraded = this.upgradeMap.get(insn.desc);
                    if (upgraded == null) continue;
                    insn.desc = upgraded;
                    continue;
                }
                if (rawInsn.getType() != 5) continue;
                insn = (MethodInsnNode)rawInsn;
                if (!insn.name.equals("<init>") || (upgraded = this.upgradeMap.get(insn.owner)) == null) continue;
                insn.owner = upgraded;
            }
        }
    }
}

