/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.SharedConfig;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DeprecatedRedirectTransformer
extends Remapper
implements RfbClassTransformer {
    final String[] fromPrefixes = new String[]{"java/lang/Compiler", "java/lang/SecurityManager"};
    final String[] toPrefixes = new String[]{"com/gtnewhorizons/retrofuturabootstrap/asm/DummyCompiler", "com/gtnewhorizons/retrofuturabootstrap/SecurityManager"};
    final byte[][] quickScans;
    final String[] excludedPackages = (String[])Stream.concat(Arrays.stream(this.fromPrefixes), Arrays.stream(this.toPrefixes)).map((? super T s) -> s.replace('/', '.')).toArray(String[]::new);

    public DeprecatedRedirectTransformer() {
        this.quickScans = (byte[][])Arrays.stream(this.fromPrefixes).map((? super T s) -> s.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
    }

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "undeprecator";
    }

    @Override
    public @NotNull String @Nullable [] additionalExclusions() {
        return this.excludedPackages;
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        int classVersion = classNode.getOriginalMetadata() != null ? classNode.getOriginalMetadata().majorVersion : 8;
        if (classVersion >= 65) {
            return false;
        }
        byte[] original = classNode.getOriginalBytes();
        if (original == null) {
            return false;
        }
        for (byte[] pattern : this.quickScans) {
            if (!ClassHeaderMetadata.hasSubstring(original, pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode inputNode = classNode.getNode();
        if (inputNode == null) {
            return;
        }
        ClassNode outputNode = new ClassNode();
        ClassRemapper visitor = new ClassRemapper((ClassVisitor)outputNode, (Remapper)this);
        try {
            inputNode.accept((ClassVisitor)visitor);
        }
        catch (Exception e) {
            SharedConfig.logWarning("Couldn't remap class " + className, e);
            return;
        }
        if (outputNode.methods != null) {
            for (MethodNode mn : outputNode.methods) {
                if (mn.instructions == null) continue;
                for (AbstractInsnNode insn : mn.instructions) {
                    if (insn.getOpcode() != 184) continue;
                    MethodInsnNode minsn = (MethodInsnNode)insn;
                    if (!"java/lang/System".equals(minsn.owner) || !"getSecurityManager".equals(minsn.name) && !"setSecurityManager".equals(minsn.name)) continue;
                    minsn.owner = "com/gtnewhorizons/retrofuturabootstrap/SecurityManager";
                }
            }
        }
        classNode.setNode(outputNode);
    }

    public String map(String typeName) {
        if (typeName == null) {
            return null;
        }
        for (int pfx = 0; pfx < this.fromPrefixes.length; ++pfx) {
            if (!typeName.startsWith(this.fromPrefixes[pfx])) continue;
            return this.toPrefixes[pfx] + typeName.substring(this.fromPrefixes[pfx].length());
        }
        return typeName;
    }
}

