/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.api;

import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformerHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPlugin;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RfbPluginHandle {
    @NotNull
    private final RfbPluginMetadata metadata;
    @NotNull
    private final RfbPlugin plugin;
    @NotNull
    private final List<RfbClassTransformerHandle> transformers;
    @NotNull
    private final List<RfbClassTransformerHandle> transformersView;
    @NotNull
    private final Map<String, RfbClassTransformerHandle> transformersNameMap;

    public RfbPluginHandle(@NotNull RfbPluginMetadata metadata, @NotNull RfbPlugin plugin) {
        this.metadata = metadata;
        this.plugin = plugin;
        this.transformers = new ArrayList<RfbClassTransformerHandle>(4);
        this.transformersView = Collections.unmodifiableList(this.transformers);
        this.transformersNameMap = new HashMap<String, RfbClassTransformerHandle>(4);
    }

    @NotNull
    public RfbPluginMetadata metadata() {
        return this.metadata;
    }

    @NotNull
    public RfbPlugin plugin() {
        return this.plugin;
    }

    @NotNull
    public List<RfbClassTransformerHandle> transformers() {
        return this.transformersView;
    }

    @Nullable
    public RfbClassTransformerHandle findTransformerById(@NotNull String id) {
        return this.transformersNameMap.get(id);
    }

    public void registerAdditionalTransformer(@NotNull RfbClassTransformerHandle handle) {
        Objects.requireNonNull(handle);
        if (handle.plugin() != this.plugin) {
            throw new IllegalArgumentException("Trying to add a transformer " + handle.id() + " to mismatched plugin " + this.metadata.id());
        }
        RfbClassTransformer xformer = handle.transformer();
        if (this.transformersNameMap.putIfAbsent(xformer.id(), handle) != null) {
            throw new IllegalArgumentException("Trying to register a transformer with a duplicate name: " + handle.id());
        }
        this.transformers.add(handle);
    }
}

