/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.base.Throwables;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, FMLMessage.EntityMessage msg) throws Exception {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        } else if (msg.getClass().equals(FMLMessage.EntityAdjustMessage.class)) {
            this.adjustEntity((FMLMessage.EntityAdjustMessage)msg);
        }
    }

    private void adjustEntity(FMLMessage.EntityAdjustMessage msg) {
        sa ent = FMLClientHandler.instance().getWorldClient().a(msg.entityId);
        if (ent != null) {
            ent.bZ = msg.serverX;
            ent.ca = msg.serverY;
            ent.cb = msg.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", msg.entityId);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        if (er == null) {
            throw new RuntimeException("Could not spawn mod entity ModID: " + spawnMsg.modId + " EntityID: " + spawnMsg.modEntityTypeId + " at ( " + spawnMsg.scaledX + "," + spawnMsg.scaledY + ", " + spawnMsg.scaledZ + ") Please contact mod author or server admin.");
        }
        bjf wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends sa> cls = er.getEntityClass();
        try {
            sa entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(spawnMsg);
            } else {
                sa[] parts;
                entity = cls.getConstructor(ahb.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.y();
                entity.d(spawnMsg.entityId);
                entity.b(spawnMsg.scaledX, spawnMsg.scaledY, spawnMsg.scaledZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof sw) {
                    ((sw)entity).aO = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.at()) != null) {
                    for (int j = 0; j < parts.length; ++j) {
                        parts[j].d(parts[j].y() + offset);
                    }
                }
            }
            entity.bZ = spawnMsg.rawX;
            entity.ca = spawnMsg.rawY;
            entity.cb = spawnMsg.rawZ;
            bjk clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                bjk thrower = clientPlayer.y() == spawnMsg.throwerId ? clientPlayer : wc.a(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((sa)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.z().a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.i(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.a(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "A severe problem occurred during the spawning of an entity at ( " + spawnMsg.scaledX + "," + spawnMsg.scaledY + ", " + spawnMsg.scaledZ + ")", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

