/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.forge;

import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.Coord;
import bspkrs.util.ModulusBlockID;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ForgeEventHandler {
    private Map<String, Boolean> playerSneakingMap = new ConcurrentHashMap<String, Boolean>(64);
    private Map<CachedBreakSpeed, Float> breakSpeedCache = new ConcurrentHashMap<CachedBreakSpeed, Float>(64);

    @SubscribeEvent
    public void onBlockClicked(PlayerInteractEvent event) {
        if (TreecapitatorMod.proxy.isEnabled() && !TCSettings.sneakAction.equalsIgnoreCase("none") && event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) && !event.entityPlayer.field_70170_p.func_147437_c(event.x, event.y, event.z)) {
            this.playerSneakingMap.put(event.entityPlayer.func_146103_bH().getName(), event.entityPlayer.func_70093_af());
        }
    }

    @SubscribeEvent
    public void getPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        TreeDefinition treeDef;
        ModulusBlockID blockID = new ModulusBlockID(event.block, event.metadata, 4);
        if (TreecapitatorMod.proxy.isEnabled() && (TreeRegistry.instance().isRegistered((BlockID)blockID) || TCSettings.allowAutoTreeDetection && TreeRegistry.canAutoDetect(event.entityPlayer.field_70170_p, event.block, event.x, event.y, event.z)) && Treecapitator.isBreakingPossible(event.entityPlayer, event.block, event.metadata, false) && (treeDef = TCSettings.allowAutoTreeDetection ? TreeRegistry.autoDetectTree(event.entityPlayer.field_70170_p, (BlockID)blockID, new Coord(event.x, event.y, event.z), TCSettings.allowDebugLogging) : TreeRegistry.instance().get((BlockID)blockID)) != null) {
            Boolean isSneaking = this.playerSneakingMap.get(event.entityPlayer.func_146103_bH().getName());
            boolean swappedSneak = (isSneaking == null || isSneaking.booleanValue() != event.entityPlayer.func_70093_af()) && isSneaking != null;
            CachedBreakSpeed cachedBreakSpeed = new CachedBreakSpeed(event, swappedSneak);
            Float newBreakSpeed = this.breakSpeedCache.get((Object)cachedBreakSpeed);
            if (newBreakSpeed == null) {
                if (!swappedSneak) {
                    if (TCSettings.treeHeightDecidesBreakSpeed) {
                        int height;
                        if (Treecapitator.isBreakingEnabled(event.entityPlayer) && (height = Treecapitator.getTreeHeight(treeDef, event.entityPlayer.field_70170_p, event.x, event.y, event.z, event.metadata, event.entityPlayer)) > 1) {
                            event.newSpeed = event.originalSpeed / ((float)height * TCSettings.treeHeightModifier);
                        }
                    } else if (Treecapitator.isBreakingEnabled(event.entityPlayer)) {
                        event.newSpeed = event.originalSpeed * treeDef.breakSpeedModifier();
                    }
                } else {
                    event.newSpeed = 0.0f;
                }
                this.breakSpeedCache.put(cachedBreakSpeed, Float.valueOf(event.newSpeed));
            } else {
                event.newSpeed = newBreakSpeed.floatValue();
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.BreakEvent event) {
        if (event.block != null && event.world != null && event.getPlayer() != null) {
            if (TreecapitatorMod.proxy.isEnabled() && !event.world.field_72995_K) {
                ModulusBlockID blockID = new ModulusBlockID(event.block, event.blockMetadata, 4);
                if ((TreeRegistry.instance().isRegistered((BlockID)blockID) || TCSettings.allowAutoTreeDetection && TreeRegistry.canAutoDetect(event.world, event.block, event.x, event.y, event.z)) && Treecapitator.isBreakingPossible(event.getPlayer(), event.block, event.blockMetadata, TCSettings.allowDebugLogging)) {
                    Coord blockPos = new Coord(event.x, event.y, event.z);
                    if (TreeRegistry.instance().trackTreeChopEventAt(blockPos)) {
                        TCLog.debug("BlockID " + blockID + " is a log.", new Object[0]);
                        TreeDefinition treeDef = TCSettings.allowAutoTreeDetection ? TreeRegistry.autoDetectTree(event.world, (BlockID)blockID, blockPos, TCSettings.allowDebugLogging) : TreeRegistry.instance().get((BlockID)blockID);
                        if (treeDef != null) {
                            new Treecapitator(event.getPlayer(), treeDef).onBlockHarvested(event.world, event.x, event.y, event.z, event.blockMetadata);
                        }
                        TreeRegistry.instance().endTreeChopEventAt(blockPos);
                    } else {
                        TCLog.debug("Previous chopping event detected for block @%s", blockPos.toString());
                    }
                }
            }
            this.cleanUpCaches(event.getPlayer());
            if (ModConfigRegistry.instance().isChanged()) {
                ModConfigRegistry.instance().writeChangesToConfig(TCConfigHandler.instance().getConfig());
            }
        }
    }

    public void cleanUpCaches(EntityPlayer player) {
        ArrayList<CachedBreakSpeed> toRemove = new ArrayList<CachedBreakSpeed>();
        for (CachedBreakSpeed bs : this.breakSpeedCache.keySet()) {
            if (!bs.entityPlayer.func_146103_bH().getName().equals(player.func_146103_bH().getName())) continue;
            toRemove.add(bs);
        }
        for (CachedBreakSpeed bs : toRemove) {
            this.breakSpeedCache.remove((Object)bs);
        }
        if (this.playerSneakingMap.containsKey(player.func_146103_bH().getName())) {
            this.playerSneakingMap.remove(player.func_146103_bH().getName());
        }
    }

    private class CachedBreakSpeed
    extends PlayerEvent.BreakSpeed {
        private boolean isSneaking;
        private boolean swappedSneak;

        public CachedBreakSpeed(PlayerEvent.BreakSpeed event, boolean swappedSneak) {
            super(event.entityPlayer, event.block, event.metadata, event.originalSpeed, event.x, event.y, event.z);
            this.isSneaking = event.entityPlayer.func_70093_af();
            this.swappedSneak = swappedSneak;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedBreakSpeed)) {
                return false;
            }
            CachedBreakSpeed bs = (CachedBreakSpeed)((Object)o);
            ItemStack oItem = bs.entityPlayer.func_71045_bC();
            ItemStack thisItem = this.entityPlayer.func_71045_bC();
            return bs.entityPlayer.func_146103_bH().getName().equals(this.entityPlayer.func_146103_bH().getName()) && (oItem != null && oItem.func_77973_b() != null ? thisItem != null && thisItem.func_77973_b() != null && GameData.getItemRegistry().func_148750_c((Object)thisItem.func_77973_b()).equals(GameData.getItemRegistry().func_148750_c((Object)oItem.func_77973_b())) : thisItem == null || thisItem.func_77973_b() == null) && GameData.getBlockRegistry().func_148750_c((Object)bs.block).equals(GameData.getBlockRegistry().func_148750_c((Object)this.block)) && bs.isSneaking == this.isSneaking && bs.swappedSneak == this.swappedSneak && bs.metadata == this.metadata && bs.originalSpeed == this.originalSpeed && bs.x == this.x && bs.y == this.y && bs.z == this.z;
        }

        public int hashCode() {
            ItemStack thisItem = this.entityPlayer.func_71045_bC();
            HashFunction hf = Hashing.md5();
            Hasher h = hf.newHasher().putString((CharSequence)this.entityPlayer.func_146103_bH().getName(), Charsets.UTF_8).putString((CharSequence)GameData.getBlockRegistry().func_148750_c((Object)this.block), Charsets.UTF_8).putBoolean(this.isSneaking).putBoolean(this.swappedSneak).putInt(this.metadata).putFloat(this.originalSpeed).putInt(this.x + this.z << 8 + this.y << 16);
            if (thisItem != null && thisItem.func_77973_b() != null) {
                h.putString((CharSequence)GameData.getItemRegistry().func_148750_c((Object)thisItem.func_77973_b()), Charsets.UTF_8).putInt(thisItem.func_77960_j());
            }
            return h.hash().hashCode();
        }
    }
}

