/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.bloodAltarUpgrade;

import WayofTime.alchemicalWizardry.api.BlockStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class AltarComponent {
    private final int x;
    private final int y;
    private final int z;
    private final List<BlockStack> validBlocks;
    private final boolean isBloodRune;
    private final boolean isUpgradeSlot;

    public AltarComponent(int x, int y, int z, Block block, int metadata, boolean isBloodRune, boolean isUpgradeSlot) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.validBlocks = new ArrayList<BlockStack>();
        this.validBlocks.add(new BlockStack(block, metadata));
        this.isBloodRune = isBloodRune;
        this.isUpgradeSlot = isUpgradeSlot;
    }

    public AltarComponent(int x, int y, int z, List<BlockStack> validBlocks, boolean isBloodRune, boolean isUpgradeSlot) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.validBlocks = validBlocks;
        this.isBloodRune = isBloodRune;
        this.isUpgradeSlot = isUpgradeSlot;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Block getBlock() {
        if (this.anyBlockMatches()) {
            return Blocks.field_150350_a;
        }
        return this.validBlocks.get(0).getBlock();
    }

    public int getMetadata() {
        if (this.anyBlockMatches()) {
            return Short.MAX_VALUE;
        }
        return this.validBlocks.get(0).getMeta();
    }

    public boolean isBloodRune() {
        return this.isBloodRune;
    }

    public boolean isUpgradeSlot() {
        return this.isUpgradeSlot;
    }

    public List<BlockStack> getValidBlocks() {
        return this.validBlocks;
    }

    public boolean matches(Block block, int meta) {
        if (this.anyBlockMatches()) {
            return true;
        }
        for (BlockStack pair : this.validBlocks) {
            if (pair.getBlock() != block || pair.getMeta() != meta && pair.getMeta() != Short.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    public boolean anyBlockMatches() {
        return this.validBlocks.isEmpty();
    }
}

