/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.Altar")
public class BloodAltar {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int tier, int lp, @Optional int consume, @Optional int drain) {
        consume = consume > 0 ? consume : 20;
        drain = drain > 0 ? drain : 20;
        MineTweakerAPI.apply((IUndoableAction)new Add(new AltarRecipe(MTHelper.toStack(output), MTHelper.toStack(input), tier, lp, consume, drain, false)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Add
    implements IUndoableAction {
        private final AltarRecipe recipe;

        public Add(AltarRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AltarRecipeRegistry.altarRecipes.add(this.recipe);
        }

        public boolean canUndo() {
            return AltarRecipeRegistry.altarRecipes != null;
        }

        public void undo() {
            AltarRecipeRegistry.altarRecipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Blood Altar Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Blood Altar Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        private AltarRecipe recipe;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (AltarRecipe r : AltarRecipeRegistry.altarRecipes) {
                if (r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                this.recipe = r;
                break;
            }
            AltarRecipeRegistry.altarRecipes.remove(this.recipe);
        }

        public boolean canUndo() {
            return AltarRecipeRegistry.altarRecipes != null && this.recipe != null;
        }

        public void undo() {
            AltarRecipeRegistry.altarRecipes.add(this.recipe);
        }

        public String describe() {
            return "Removing Blood Altar Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Blood Altar Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

