/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.entity.boss;

import cpw.mods.fml.common.network.NetworkRegistry;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT5;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class EntityGhastBoss
extends EntityFlying
implements IEntityBreathable,
IBossDisplayData,
IRangedAttackMob,
IBoss {
    protected long ticks = 0L;
    private TileEntityDungeonSpawner spawnerven;
    public int headsRemaining = 3;
    public Entity targetEntity;
    public int deathTicks = 0;
    public int entitiesWithin;
    public int entitiesWithinLast;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;
    private Entity targetedEntity;
    private int explosionStrength = 1;
    private Vector3 roomCoords;
    private Vector3 roomSize;
    private boolean mode = false;
    private int count;

    public EntityGhastBoss(World world) {
        super(world);
        this.func_70105_a(1.8f, 7.0f);
        this.field_70178_ae = true;
    }

    public boolean func_70097_a(DamageSource damagSource, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if ("fireball".equals(damagSource.func_76355_l()) && damagSource.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(damagSource, amount);
            return true;
        }
        return super.func_70097_a(damagSource, Math.min(amount, GSConfigCore.baseBossDamage));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(450.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.05f);
    }

    public EntityGhastBoss(World world, Vector3 vec) {
        this(world);
        this.func_70107_b(vec.x, vec.y, vec.z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70653_a(Entity entity, float amount, double p_70653_3_, double p_70653_5_) {
    }

    protected String func_70639_aQ() {
        return "mob.ghast.moan";
    }

    protected String func_70621_aR() {
        return "mob.ghast.scream";
    }

    protected String func_70673_aS() {
        return "mob.ghast.death";
    }

    protected void func_70626_be() {
        this.prevAttackCounter = this.attackCounter;
        double dX = this.waypointX - this.field_70165_t;
        double dY = this.waypointY - this.field_70163_u;
        double dZ = this.waypointZ - this.field_70161_v;
        double dSq = dX * dX + dY * dY + dZ * dZ;
        if (dSq < 1.0 || dSq > 3600.0) {
            this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(dSq = (double)MathHelper.func_76133_a((double)dSq))) {
                this.field_70159_w += dX / dSq * 0.1;
                this.field_70181_x += dY / dSq * 0.1;
                this.field_70179_y += dZ / dSq * 0.1;
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < 4096.0) {
            float n;
            double dX2 = this.targetedEntity.field_70165_t - this.field_70165_t;
            double dY2 = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double dZ2 = this.targetedEntity.field_70161_v - this.field_70161_v;
            this.field_70177_z = n = -((float)Math.atan2(dX2, dZ2)) * 180.0f / (float)Math.PI;
            this.field_70761_aq = n;
            if (this.func_70685_l(this.targetedEntity)) {
                Vec3 lookVec;
                EntityLargeFireball fireball;
                if (this.attackCounter == 10) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1007, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                }
                ++this.attackCounter;
                if (this.attackCounter == 20 && !this.mode) {
                    if (this.field_70146_Z.nextInt(5) == 1) {
                        this.mode = true;
                    }
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX2, dY2, dZ2);
                    fireball.field_92057_e = this.explosionStrength;
                    lookVec = this.func_70676_i(1.0f);
                    fireball.field_70165_t = this.field_70165_t + lookVec.field_72450_a * 4.0;
                    fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 5.0f) + 0.5;
                    fireball.field_70161_v = this.field_70161_v + lookVec.field_72449_c * 4.0;
                    this.field_70170_p.func_72838_d((Entity)fireball);
                    this.attackCounter = 0;
                }
                if (this.mode && this.attackCounter == 8) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX2, dY2, dZ2);
                    fireball.field_92057_e = this.explosionStrength;
                    lookVec = this.func_70676_i(1.0f);
                    fireball.field_70165_t = this.field_70165_t + lookVec.field_72450_a * 4.0;
                    fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 5.0f) + 0.5;
                    fireball.field_70161_v = this.field_70161_v + lookVec.field_72449_c * 4.0;
                    this.field_70170_p.func_72838_d((Entity)fireball);
                    this.attackCounter = 0;
                    ++this.count;
                }
                if (this.count == 8) {
                    this.mode = false;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            float n2;
            this.field_70177_z = n2 = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            this.field_70761_aq = n2;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            int var13;
            int var12 = (Integer)this.field_70180_af.func_75691_i(16).func_75669_b();
            int n = var13 = this.attackCounter > 10 ? 1 : 0;
            if (var12 != var13) {
                this.field_70180_af.func_75692_b(16, (Object)var13);
            }
        }
    }

    private boolean isCourseTraversable(double dist) {
        double dX = (this.waypointX - this.field_70165_t) / dist;
        double dY = (this.waypointY - this.field_70163_u) / dist;
        double dZ = (this.waypointZ - this.field_70161_v) / dist;
        AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < dist) {
            aabb.func_72317_d(dX, dY, dZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void func_70609_aI() {
        float n;
        ++this.deathTicks;
        this.headsRemaining = 0;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float rX = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float rY = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float rZ = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)rX, this.field_70163_u + 2.0 + (double)rY, this.field_70161_v + (double)rZ, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int xpSplit;
                for (int xp = 30; xp > 0; xp -= xpSplit) {
                    xpSplit = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, xpSplit));
                }
            }
            if (this.deathTicks == 1) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70177_z = n = this.field_70177_z + 20.0f;
        this.field_70761_aq = n;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int xpSplit;
            for (int xp = 20; xp > 0; xp -= xpSplit) {
                xpSplit = EntityXPOrb.func_70527_a((int)xp);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, xpSplit));
            }
            for (TileEntity tile : this.field_70170_p.field_147482_g) {
                if (!(tile instanceof TileEntityTreasureChestT5)) continue;
                TileEntityTreasureChestT5 chest = (TileEntityTreasureChestT5)tile;
                double dX = (double)chest.field_145851_c + 0.5 - this.field_70165_t;
                double dY = (double)chest.field_145848_d + 0.5 - this.field_70163_u;
                double dZ = (double)chest.field_145849_e + 0.5 - this.field_70161_v;
                if (!(dX * dX + dY * dY + dZ * dZ < 10000.0)) continue;
                if (!chest.locked) {
                    chest.locked = true;
                }
                for (int k = 0; k < chest.func_70302_i_(); ++k) {
                    chest.func_70299_a(k, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                chest.func_70299_a(this.field_70146_Z.nextInt(chest.func_70302_i_()), this.getGuaranteedLoot(this.field_70146_Z));
                break;
            }
            this.func_70099_a(new ItemStack(GSItems.Tier5Key, 1), 0.5f);
            super.func_70106_y();
            if (this.spawnerven != null) {
                this.spawnerven.isBossDefeated = true;
                this.spawnerven.boss = null;
                this.spawnerven.spawned = false;
            }
        }
    }

    public void func_70106_y() {
        if (this.spawnerven != null) {
            this.spawnerven.isBossDefeated = false;
            this.spawnerven.boss = null;
            this.spawnerven.spawned = false;
        }
        super.func_70106_y();
    }

    public void func_70636_d() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (this.func_110143_aJ() <= 0.0f) {
            this.headsRemaining = 0;
        } else if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() / 3.0) {
            this.headsRemaining = 1;
        } else if ((double)this.func_110143_aJ() <= 2.0 * ((double)this.func_110138_aP() / 3.0)) {
            this.headsRemaining = 2;
        }
        EntityPlayer player = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0);
        if (player != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        new Vector3((Entity)this);
        if (this.roomCoords != null && this.roomSize != null) {
            List entitiesWithin_ = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 1), (double)(this.roomCoords.intY() - 1), (double)(this.roomCoords.intZ() - 1), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ())));
            this.entitiesWithin = entitiesWithin_.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                List entitiesWithin2 = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 11), (double)(this.roomCoords.intY() - 11), (double)(this.roomCoords.intZ() - 11), (double)(this.roomCoords.intX() + this.roomSize.intX() + 10), (double)(this.roomCoords.intY() + this.roomSize.intY() + 10), (double)(this.roomCoords.intZ() + this.roomSize.intZ() + 10)));
                for (EntityPlayer p : entitiesWithin2) {
                    p.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.skeletonBoss.message")));
                }
                this.func_70106_y();
                if (this.spawnerven != null) {
                    this.spawnerven.playerCheated = true;
                }
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
    }

    public EntityItem func_70099_a(ItemStack itemStackIn, float offsetY) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, itemStackIn);
        entityitem.field_70181_x = -2.0;
        entityitem.field_145804_b = 10;
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public boolean canBreath() {
        return true;
    }

    public ItemStack getGuaranteedLoot(Random rand_) {
        List stackList = GalacticraftRegistry.getDungeonLoot((int)5);
        return ((ItemStack)stackList.get(rand_.nextInt(stackList.size()))).func_77946_l();
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi();
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.roomCoords != null) {
            tagCompound.func_74780_a("roomCoordsX", this.roomCoords.x);
            tagCompound.func_74780_a("roomCoordsY", this.roomCoords.y);
            tagCompound.func_74780_a("roomCoordsZ", this.roomCoords.z);
            tagCompound.func_74780_a("roomSizeX", this.roomSize.x);
            tagCompound.func_74780_a("roomSizeY", this.roomSize.y);
            tagCompound.func_74780_a("roomSizeZ", this.roomSize.z);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.roomCoords = new Vector3();
        this.roomCoords.x = tagCompound.func_74769_h("roomCoordsX");
        this.roomCoords.y = tagCompound.func_74769_h("roomCoordsY");
        this.roomCoords.z = tagCompound.func_74769_h("roomCoordsZ");
        this.roomSize = new Vector3();
        this.roomSize.x = tagCompound.func_74769_h("roomSizeX");
        this.roomSize.y = tagCompound.func_74769_h("roomSizeY");
        this.roomSize.z = tagCompound.func_74769_h("roomSizeZ");
    }

    private double func_82214_u(int par1) {
        if (par1 <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (par1 - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f2 * 1.3;
    }

    private double func_82208_v(int par1) {
        return par1 <= 0 ? this.field_70163_u + 6.0 : this.field_70163_u + 4.2;
    }

    private double func_82213_w(int par1) {
        if (par1 <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (par1 - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f2 * 1.3;
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        this.launchFireballToEntity(0, entity);
    }

    private void launchFireballToEntity(int par1, EntityLivingBase entity) {
        this.launchFireballToCoords(par1, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() / 2.0, entity.field_70161_v);
    }

    private void launchFireballToCoords(int par1, double x, double y, double z) {
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1014, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        double newX = this.func_82214_u(par1);
        double newY = this.func_82208_v(par1);
        double newZ = this.func_82213_w(par1);
        double dX = x - newX;
        double dY = y - newY;
        double dZ = z - newZ;
        EntityLargeFireball entityfireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX * 0.5, dY * 0.5, dZ * 0.5);
        entityfireball.field_70163_u = newY;
        entityfireball.field_70165_t = newX;
        entityfireball.field_70161_v = newZ;
        this.field_70170_p.func_72838_d((Entity)entityfireball);
    }

    public void setRoom(Vector3 roomCoords, Vector3 roomSize) {
        this.roomCoords = roomCoords;
        this.roomSize = roomSize;
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawnerven = spawner;
    }
}

