/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import chylex.hee.system.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPosM {
    private static final ThreadLocal<BlockPosM> temporary = new ThreadLocal<BlockPosM>(){

        @Override
        protected BlockPosM initialValue() {
            return new BlockPosM();
        }
    };
    public int x;
    public int y;
    public int z;

    public static AxisAlignedBB getBoundingBox(BlockPosM loc1, BlockPosM loc2) {
        return AxisAlignedBB.func_72330_a((double)Math.min(loc1.x, loc2.x), (double)loc1.y, (double)Math.min(loc1.z, loc2.z), (double)Math.max(loc1.x, loc2.x), (double)loc2.y, (double)Math.max(loc1.z, loc2.z));
    }

    public static BlockPosM fromNBT(NBTTagCompound nbt, String key) {
        return nbt.func_150297_b(key, 4) ? new BlockPosM(nbt.func_74763_f(key)) : new BlockPosM(nbt.func_74759_k(key));
    }

    public static BlockPosM tmp() {
        return temporary.get().set(0, 0, 0);
    }

    public static BlockPosM tmp(int x, int y, int z) {
        return temporary.get().set(x, y, z);
    }

    public static BlockPosM tmp(int[] array3) {
        return temporary.get().set(array3);
    }

    public static BlockPosM tmp(double x, double y, double z) {
        return temporary.get().set(x, y, z);
    }

    public static BlockPosM tmp(BlockPosM pos) {
        return temporary.get().set(pos);
    }

    public static BlockPosM tmp(Entity entity) {
        return temporary.get().set(entity);
    }

    public static BlockPosM tmp(long serialized) {
        return temporary.get().set(serialized);
    }

    public BlockPosM() {
    }

    public BlockPosM(int x, int y, int z) {
        this.set(x, y, z);
    }

    public BlockPosM(int[] array3) {
        this.set(array3);
    }

    public BlockPosM(double x, double y, double z) {
        this.set(x, y, z);
    }

    public BlockPosM(Entity entity) {
        this.set(entity);
    }

    public BlockPosM(long serialized) {
        this.set(serialized);
    }

    public BlockPosM setX(int x) {
        this.x = x;
        return this;
    }

    public BlockPosM setY(int y) {
        this.y = y;
        return this;
    }

    public BlockPosM setZ(int z) {
        this.z = z;
        return this;
    }

    public BlockPosM set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public BlockPosM set(int[] array3) {
        if (array3 == null || array3.length != 3) {
            array3 = new int[]{0, 0, 0};
        }
        return this.set(array3[0], array3[1], array3[2]);
    }

    public BlockPosM set(double x, double y, double z) {
        return this.set(MathUtil.floor(x), MathUtil.floor(y), MathUtil.floor(z));
    }

    public BlockPosM set(BlockPosM pos) {
        return this.set(pos.x, pos.y, pos.z);
    }

    public BlockPosM set(Entity entity) {
        return this.set(MathUtil.floor(entity.field_70165_t), MathUtil.floor(entity.field_70163_u), MathUtil.floor(entity.field_70161_v));
    }

    public BlockPosM set(long serialized) {
        return this.set((int)(serialized >> 38), (int)(serialized << 26 >> 52), (int)(serialized << 38 >> 38));
    }

    public BlockPosM move(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public BlockPosM move(int side) {
        return this.move(EnumFacing.values()[side]);
    }

    public BlockPosM move(int side, int amount) {
        return this.move(EnumFacing.values()[side], amount);
    }

    public BlockPosM move(EnumFacing facing) {
        return this.move(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
    }

    public BlockPosM move(EnumFacing facing, int amount) {
        return this.move(facing.func_82601_c() * amount, facing.func_96559_d() * amount, facing.func_82599_e() * amount);
    }

    public BlockPosM moveUp() {
        return this.move(EnumFacing.UP);
    }

    public BlockPosM moveDown() {
        return this.move(EnumFacing.DOWN);
    }

    public BlockPosM moveNorth() {
        return this.move(EnumFacing.NORTH);
    }

    public BlockPosM moveSouth() {
        return this.move(EnumFacing.SOUTH);
    }

    public BlockPosM moveEast() {
        return this.move(EnumFacing.EAST);
    }

    public BlockPosM moveWest() {
        return this.move(EnumFacing.WEST);
    }

    public boolean setAir(World world) {
        return world.func_147468_f(this.x, this.y, this.z);
    }

    public boolean setBlock(World world, Block block) {
        return world.func_147449_b(this.x, this.y, this.z, block);
    }

    public boolean setBlock(World world, Block block, int metadata) {
        return world.func_147465_d(this.x, this.y, this.z, block, metadata, 3);
    }

    public boolean setBlockOnlyLoaded(World world, Block block, int metadata) {
        if (!world.func_72899_e(this.x, this.y, this.z)) {
            return false;
        }
        return world.func_147465_d(this.x, this.y, this.z, block, metadata, 3);
    }

    public boolean setBlock(World world, Block block, int metadata, int flags) {
        return world.func_147465_d(this.x, this.y, this.z, block, metadata, flags);
    }

    public boolean setMetadata(World world, int metadata) {
        return world.func_72921_c(this.x, this.y, this.z, metadata, 3);
    }

    public boolean setMetadata(World world, int metadata, int flags) {
        return world.func_72921_c(this.x, this.y, this.z, metadata, flags);
    }

    public boolean isAir(World world) {
        return world.func_147437_c(this.x, this.y, this.z);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public Material getMaterial(IBlockAccess world) {
        return world.func_147439_a(this.x, this.y, this.z).func_149688_o();
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public boolean checkBlock(World world, Block block, int metadata) {
        return world.func_147439_a(this.x, this.y, this.z) == block && world.func_72805_g(this.x, this.y, this.z) == metadata;
    }

    public BlockPosM copy() {
        return new BlockPosM(this.x, this.y, this.z);
    }

    public long toLong() {
        return ((long)this.x & 0x3FFFFFFL) << 38 | ((long)this.y & 0xFFFL) << 26 | (long)this.z & 0x3FFFFFFL;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockPosM) {
            BlockPosM pos = (BlockPosM)obj;
            return pos.x == this.x && pos.y == this.y && pos.z == this.z;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (this.y + this.z * 31) * 31 + this.x;
    }

    public String toString() {
        return "{ " + this.x + ", " + this.y + ", " + this.z + " }";
    }
}

