/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.util;

import java.util.Random;

public final class WorldGenChance {
    public static final WorldGenChance2 linear2Incr = new WorldGenChance2(){

        @Override
        public double calculate(double dist, double startDist, double endDist) {
            return dist < startDist ? 0.0 : (dist > endDist ? 1.0 : (dist - startDist) / (endDist - startDist));
        }
    };
    public static final WorldGenChance2 linear2Decr = new WorldGenChance2(){

        @Override
        public double calculate(double dist, double startDist, double endDist) {
            return dist < startDist || dist > endDist ? 0.0 : 1.0 - (dist - startDist) / (endDist - startDist);
        }
    };
    public static final WorldGenChance2 cubic2Incr = new WorldGenChance2(){

        @Override
        public double calculate(double dist, double startDist, double endDist) {
            return dist < startDist ? 0.0 : (dist > endDist ? 1.0 : Math.pow((dist - startDist) / (endDist - startDist), 3.0));
        }
    };
    public static final WorldGenChance2 cubic2Decr = new WorldGenChance2(){

        @Override
        public double calculate(double dist, double startDist, double endDist) {
            return dist < startDist || dist > endDist ? 0.0 : 1.0 - Math.pow((dist - startDist) / (endDist - startDist), 3.0);
        }
    };
    public static final WorldGenChance3 linear3IncrDecr = new WorldGenChance3(){

        @Override
        public double calculate(double dist, double startDist, double middleDist, double endDist) {
            return dist < startDist || dist > endDist ? 0.0 : (dist < middleDist ? linear2Incr.calculate(dist, startDist, middleDist) : linear2Decr.calculate(dist, middleDist, endDist));
        }
    };

    public static boolean checkChance(double chance, Random rand) {
        return chance == 0.0 ? false : (chance == 1.0 ? true : rand.nextDouble() < chance);
    }

    private WorldGenChance() {
    }

    public static abstract class WorldGenChance2 {
        private WorldGenChance2() {
        }

        public abstract double calculate(double var1, double var3, double var5);
    }

    public static abstract class WorldGenChance3 {
        private WorldGenChance3() {
        }

        public abstract double calculate(double var1, double var3, double var5, double var7);
    }
}

