/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TypedMethod<T> {
    private Method field;
    private Class<T> cls;

    public TypedMethod(Method method, Class<T> cls) {
        this.field = method;
        this.cls = cls;
    }

    public T call(Object obj, Object ... args) {
        try {
            Object res = this.field.invoke(obj, args);
            if (this.cls.isInstance(res)) {
                return (T)res;
            }
            throw new RuntimeException(String.format("Wrong return type. Expected %s, got %s", this.cls, res.getClass()));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> TypedMethod<R> from(Class<?> cls, String name, Class<R> result) throws NoSuchMethodException {
        return new TypedMethod<R>(cls.getMethod(name, new Class[0]), result);
    }
}

