/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import openmods.inventory.comparator.EqualComponents;

public class StackEqualityTesterBuilder {
    private boolean usedItem;
    private boolean usedItemId;
    private boolean usedDamage;
    private boolean usedSize;
    private boolean usedNBT;
    private List<EqualComponents.IItemStackTester> testers = Lists.newArrayList();

    public StackEqualityTesterBuilder useItem() {
        Preconditions.checkState((!this.usedItem ? 1 : 0) != 0);
        this.usedItem = true;
        this.testers.add(EqualComponents.ITEM_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useItemId() {
        Preconditions.checkState((!this.usedItemId ? 1 : 0) != 0);
        this.usedItemId = true;
        this.testers.add(EqualComponents.ITEM_ID_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useDamage() {
        Preconditions.checkState((!this.usedDamage ? 1 : 0) != 0);
        this.usedDamage = true;
        this.testers.add(EqualComponents.DAMAGE_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useSize() {
        Preconditions.checkState((!this.usedSize ? 1 : 0) != 0);
        this.usedSize = true;
        this.testers.add(EqualComponents.SIZE_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useNBT() {
        Preconditions.checkState((!this.usedNBT ? 1 : 0) != 0);
        this.usedNBT = true;
        this.testers.add(EqualComponents.NBT_TESTER);
        return this;
    }

    public IEqualityTester build() {
        ImmutableList frozenTesters = ImmutableList.copyOf(this.testers);
        return new IEqualityTester((List)frozenTesters){
            final /* synthetic */ List val$frozenTesters;
            {
                this.val$frozenTesters = list;
            }

            @Override
            public boolean isEqual(Object left, Object right) {
                if (left == right) {
                    return true;
                }
                if (left instanceof ItemStack && right instanceof ItemStack) {
                    for (EqualComponents.IItemStackTester tester : this.val$frozenTesters) {
                        if (tester.isEqual((ItemStack)left, (ItemStack)right)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public Predicate<ItemStack> buildPredicate(ItemStack template) {
        final ItemStack copy = template.func_77946_l();
        final IEqualityTester tester = this.build();
        return new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return tester.isEqual(copy, input);
            }
        };
    }

    public static interface IEqualityTester {
        public boolean isEqual(Object var1, Object var2);
    }
}

