/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.ITrackItemIconProvider;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;

public class TrackTextureLoader
implements ITextureLoader,
ITrackItemIconProvider {
    public static final TrackTextureLoader INSTANCE = new TrackTextureLoader();
    public final Map<TrackSpec, IIcon[]> textures = new HashMap<TrackSpec, IIcon[]>();
    public final Map<TrackSpec, IIcon> itemIcon = new HashMap<TrackSpec, IIcon>();

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        for (EnumTrack track : EnumTrack.VALUES) {
            if (track.getNumIcons() == 0) continue;
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, track.getTextureTag(), track.getNumIcons());
            this.textures.put(track.getTrackSpec(), icons);
            this.itemIcon.put(track.getTrackSpec(), icons[track.getItemIconIndex()]);
        }
    }

    @Override
    public IIcon getTrackItemIcon(TrackSpec spec) {
        IIcon icon = this.itemIcon.get(spec);
        if (icon == null) {
            icon = Blocks.field_150448_aq.func_149691_a(0, 0);
        }
        return icon;
    }

    public IIcon[] getTrackIcons(TrackSpec spec) {
        return this.textures.get(spec);
    }
}

