/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.api;

import java.util.ServiceLoader;
import net.glease.tc4tweak.api.BrowserPagingAPI;
import net.glease.tc4tweak.api.DummyBrowserPagingAPI;
import net.glease.tc4tweak.api.DummyInfusionExtAPI;
import net.glease.tc4tweak.api.InfusionExtAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TC4TweaksAPI {
    public static final String VERSION = "1.5.37";
    private static final Logger log = LogManager.getLogger((String)"TC4TweaksAPI");
    private static BrowserPagingAPI browserPagingAPI;
    private static InfusionExtAPI infusionExtAPI;

    public static BrowserPagingAPI getBrowserPagingAPI() {
        if (browserPagingAPI == null) {
            BrowserPagingAPI api = TC4TweaksAPI.getService(BrowserPagingAPI.class);
            if (api == null) {
                log.warn("Browser Paging API not available! Using dummy Browser Paging API.");
                browserPagingAPI = new DummyBrowserPagingAPI();
            } else {
                browserPagingAPI = api;
            }
        }
        return browserPagingAPI;
    }

    public static InfusionExtAPI getInfusionExtAPI() {
        if (infusionExtAPI == null) {
            InfusionExtAPI api = TC4TweaksAPI.getService(InfusionExtAPI.class);
            if (api == null) {
                log.warn("InfusionExt API not available! Using dummy Infusion Ext API.");
                infusionExtAPI = new DummyInfusionExtAPI();
            } else {
                infusionExtAPI = api;
            }
        }
        return infusionExtAPI;
    }

    private static <T> T getService(Class<T> serviceClass) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
        T first = null;
        for (T t : loader) {
            if (first == null) {
                first = t;
            }
            if (!t.getClass().getName().startsWith("net.glease.tc4tweak.modules.")) continue;
            return t;
        }
        return first;
    }
}

