/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.TwilightForestMod;
import twilightforest.block.StepSoundTFInsect;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public abstract class BlockTFCritter
extends Block {
    protected Item dropItem = Items.field_151114_aO;
    protected int dropMeta = 0;

    protected BlockTFCritter() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.func_149647_a(TFItems.creativeTab);
        this.field_149762_H = new StepSoundTFInsect("squish", 0.25f, 0.6f);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity instanceof IProjectile) {
            int metadata = world.func_72805_g(x, y, z);
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)this) + (metadata << 12));
            world.func_147468_f(x, y, z);
            double dx = this.func_149704_x() + world.field_73012_v.nextDouble() * (this.func_149753_y() - this.func_149704_x());
            double dy = this.func_149665_z() + world.field_73012_v.nextDouble() * (this.func_149669_A() - this.func_149665_z());
            double dz = this.func_149706_B() + world.field_73012_v.nextDouble() * (this.func_149693_C() - this.func_149706_B());
            EntityItem entityitem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, new ItemStack(this.dropItem, 1, this.dropMeta));
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int facing = world.func_72805_g(x, y, z) & 7;
        float wide = 0.15f;
        switch (facing) {
            case 1: {
                this.func_149676_a(0.0f, 0.2f, 0.5f - wide, wide * 2.0f, 0.8f, 0.5f + wide);
                break;
            }
            case 2: {
                this.func_149676_a(1.0f - wide * 2.0f, 0.2f, 0.5f - wide, 1.0f, 0.8f, 0.5f + wide);
                break;
            }
            case 3: {
                this.func_149676_a(0.5f - wide, 0.2f, 0.0f, 0.5f + wide, 0.8f, wide * 2.0f);
                break;
            }
            case 4: {
                this.func_149676_a(0.5f - wide, 0.2f, 1.0f - wide * 2.0f, 0.5f + wide, 0.8f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.5f - wide, 0.0f, 0.2f, 0.5f + wide, wide * 2.0f, 0.8f);
                break;
            }
            case 6: {
                this.func_149676_a(0.5f - wide, 1.0f - wide * 2.0f, 0.2f, 0.5f + wide, 1.0f, 0.8f);
                break;
            }
            default: {
                float f1 = 0.1f;
                this.func_149676_a(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return TwilightForestMod.proxy.getCritterBlockRenderID();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (this.canPlaceAt(world, x - 1, y, z)) {
            return true;
        }
        if (this.canPlaceAt(world, x + 1, y, z)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y, z - 1)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y, z + 1)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y - 1, z)) {
            return true;
        }
        return this.canPlaceAt(world, x, y + 1, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int placementFacing, float par6, float par7, float par8, int meta) {
        switch (placementFacing) {
            case 0: {
                if (!this.canPlaceAt(world, x, y + 1, z)) break;
                meta = 6;
                break;
            }
            case 1: {
                if (!this.canPlaceAt(world, x, y - 1, z)) break;
                meta = 5;
                break;
            }
            case 2: {
                if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) break;
                meta = 4;
                break;
            }
            case 3: {
                if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) break;
                meta = 3;
                break;
            }
            case 4: {
                if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) break;
                meta = 2;
                break;
            }
            case 5: {
                if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) break;
                meta = 1;
            }
        }
        return meta;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0) {
            if (this.canPlaceAt(world, x - 1, y, z)) {
                world.func_72921_c(x, y, z, 1, 2);
            } else if (this.canPlaceAt(world, x + 1, y, z)) {
                world.func_72921_c(x, y, z, 2, 2);
            } else if (this.canPlaceAt(world, x, y, z - 1)) {
                world.func_72921_c(x, y, z, 3, 2);
            } else if (this.canPlaceAt(world, x, y, z + 1)) {
                world.func_72921_c(x, y, z, 4, 2);
            } else if (this.canPlaceAt(world, x, y - 1, z)) {
                world.func_72921_c(x, y, z, 5, 2);
            } else if (this.canPlaceAt(world, x, y + 1, z)) {
                world.func_72921_c(x, y, z, 6, 2);
            }
        }
        this.dropCritterIfCantStay(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public boolean dropCritterIfCantStay(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockID) {
        if (this.dropCritterIfCantStay(world, x, y, z)) {
            int facing = world.func_72805_g(x, y, z) & 7;
            boolean flag = false;
            switch (facing) {
                case 1: {
                    if (this.canPlaceAt(world, x - 1, y, z)) break;
                    flag = true;
                    break;
                }
                case 2: {
                    if (this.canPlaceAt(world, x + 1, y, z)) break;
                    flag = true;
                    break;
                }
                case 3: {
                    if (this.canPlaceAt(world, x, y, z - 1)) break;
                    flag = true;
                    break;
                }
                case 4: {
                    if (this.canPlaceAt(world, x, y, z + 1)) break;
                    flag = true;
                    break;
                }
                case 5: {
                    if (this.canPlaceAt(world, x, y - 1, z)) break;
                    flag = true;
                    break;
                }
                case 6: {
                    if (this.canPlaceAt(world, x, y + 1, z)) break;
                    flag = true;
                }
            }
            if (flag) {
                this.func_149697_b(world, x, y, z, 0, 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public boolean canPlaceAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Material blockMaterial = block.func_149688_o();
        return block.isNormalCube((IBlockAccess)world, x, y, z) || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151570_A;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return TFItems.critter;
    }

    public int func_149692_a(int par1) {
        int metadata = 0;
        if (this == TFBlocks.cicada) {
            metadata = 1;
        } else if (this == TFBlocks.moonworm) {
            metadata = 2;
        }
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return TFItems.critter;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149643_k(World worldIn, int x, int y, int z) {
        return this.func_149692_a(0);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (player.func_70093_af() && player.field_71071_by.field_70460_b[3] == null) {
            player.field_71071_by.field_70460_b[3] = new ItemStack(TFItems.critter, 1, this.func_149692_a(0));
            if (!player.field_71075_bZ.field_75098_d) {
                worldIn.func_147468_f(x, y, z);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("TwilightForest:" + this.func_149739_a().substring(5));
    }
}

