/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import shukaro.warptheory.handlers.IMultiWarpEvent;
import shukaro.warptheory.handlers.ITimerWarpEvent;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.MiscHelper;

public class WarpCommand
implements ICommand {
    private java.util.function.Supplier<ImmutableMap<String, IWarpEvent>> nameMap = () -> ((Supplier)Suppliers.memoize(this::getNameMap)).get();
    private java.util.function.Supplier<ImmutableList<String>> timers = () -> ((Supplier)Suppliers.memoize(this::getTimers)).get();

    public String func_71517_b() {
        return "warptheory";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/warptheory <event> [player]";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0 || args.length > 2) {
            String events = "";
            for (String name : this.nameMap.get().keySet()) {
                events = events + name + " ";
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid Syntax, available events are: " + events));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Additional commands: print purge"));
        } else {
            EntityPlayer player = args.length == 1 ? MiscHelper.getPlayerByName(sender.func_70005_c_()) : MiscHelper.getPlayerByName(args[1]);
            if ("print".equals(args[0])) {
                boolean hasEffect = false;
                for (String name : this.nameMap.get().keySet()) {
                    int amount = MiscHelper.getWarpTag(player).func_74762_e(name);
                    if (amount <= 0) continue;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(name + ": " + amount));
                    hasEffect = true;
                }
                for (String timer : this.timers.get()) {
                    int count = MiscHelper.getWarpTag(player).func_74762_e(timer);
                    if (count <= 0) continue;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(timer + ": " + count));
                    hasEffect = true;
                }
                if (!hasEffect) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("No active warp effects!"));
                }
            } else if ("purge".equals(args[0])) {
                boolean hasEffect = false;
                for (String name : this.nameMap.get().keySet()) {
                    if (MiscHelper.getWarpTag(player).func_74762_e(name) <= 0) continue;
                    MiscHelper.getWarpTag(player).func_82580_o(name);
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Purged " + name + "!"));
                    hasEffect = true;
                }
                for (String timer : this.timers.get()) {
                    if (MiscHelper.getWarpTag(player).func_74762_e(timer) <= 0) continue;
                    MiscHelper.getWarpTag(player).func_82580_o(timer);
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Purged " + timer + "!"));
                    hasEffect = true;
                }
                if (!hasEffect) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("No active warp effects!"));
                }
            } else {
                IWarpEvent event = (IWarpEvent)this.nameMap.get().get((Object)args[0]);
                if (event == null) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Could not find warp event: " + args[0]));
                    return;
                }
                if (event instanceof IMultiWarpEvent) {
                    ((IMultiWarpEvent)event).doEvent(args[0], sender.func_130014_f_(), player);
                } else {
                    event.doEvent(sender.func_130014_f_(), player);
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText("Triggered warp event: " + args[0]));
            }
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayer player = MiscHelper.getPlayerByName(sender.func_70005_c_());
            return player.field_71075_bZ.field_75098_d || MiscHelper.isOp(sender.func_70005_c_());
        }
        return sender instanceof MinecraftServer;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (String name : this.nameMap.get().keySet()) {
                if (!name.startsWith(args[0])) continue;
                completions.add(name);
            }
            return completions;
        }
        if (args.length == 2) {
            ArrayList<String> completions = new ArrayList<String>();
            for (EntityPlayer serverPlayer : (ArrayList)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (!serverPlayer.func_70005_c_().startsWith(args[1])) continue;
                completions.add(serverPlayer.func_70005_c_());
            }
            return completions;
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int i) {
        return args.length == 2 && i == 1;
    }

    public int compareTo(Object o) {
        if (o instanceof ICommand) {
            ICommand other = (ICommand)o;
            return this.func_71517_b().compareTo(other.func_71517_b());
        }
        return 0;
    }

    private synchronized ImmutableMap<String, IWarpEvent> getNameMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IWarpEvent e : WarpHandler.warpEvents) {
            if (e instanceof IMultiWarpEvent) {
                ((IMultiWarpEvent)e).getEventLevels().values().forEach(name -> builder.put(name, (Object)e));
                continue;
            }
            builder.put((Object)e.getName(), (Object)e);
        }
        return builder.build();
    }

    private synchronized ImmutableList<String> getTimers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IWarpEvent e : WarpHandler.warpEvents) {
            if (!(e instanceof ITimerWarpEvent)) continue;
            ((ITimerWarpEvent)e).getTimers().values().forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }
}

