/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.iris;

import java.util.LinkedHashMap;
import java.util.Map;
import net.coderbot.iris.parsing.BiomeCategories;
import net.minecraft.world.biome.BiomeGenBase;

public class ModdedBiomeDetector {
    private static boolean initialized = false;
    private static Class<?> bopEndBiomeClass = null;
    private static Class<?> bopNetherBiomeClass = null;
    private static Class<?> bopOceanBiomeClass = null;
    private static final Map<Class<?>, BiomeCategories> rwgClassMap = new LinkedHashMap();

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ModdedBiomeDetector.initializeBOP();
        ModdedBiomeDetector.initializeRWG();
    }

    private static void initializeBOP() {
        try {
            bopEndBiomeClass = Class.forName("biomesoplenty.common.biome.BOPEndBiome");
            bopNetherBiomeClass = Class.forName("biomesoplenty.common.biome.BOPNetherBiome");
            bopOceanBiomeClass = Class.forName("biomesoplenty.common.biome.BOPOceanBiome");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void initializeRWG() {
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeOcean", BiomeCategories.OCEAN);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeRiver", BiomeCategories.RIVER);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomePlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeColdPlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotPlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotDesert", BiomeCategories.DESERT);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeSnowDesert", BiomeCategories.DESERT);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeJungle", BiomeCategories.JUNGLE);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeTropicalIsland", BiomeCategories.JUNGLE);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeRedwood", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeTemperateForest", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeColdForest", BiomeCategories.TAIGA);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotForest", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeSnowForest", BiomeCategories.TAIGA);
    }

    private static void tryAddRWGClass(String className, BiomeCategories category) {
        try {
            Class<?> clazz = Class.forName(className);
            rwgClassMap.put(clazz, category);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static BiomeCategories detectModdedBiome(BiomeGenBase biome) {
        if (!initialized) {
            ModdedBiomeDetector.initialize();
        }
        if (bopEndBiomeClass != null && bopEndBiomeClass.isInstance(biome)) {
            return BiomeCategories.THE_END;
        }
        if (bopNetherBiomeClass != null && bopNetherBiomeClass.isInstance(biome)) {
            return BiomeCategories.NETHER;
        }
        if (bopOceanBiomeClass != null && bopOceanBiomeClass.isInstance(biome)) {
            return BiomeCategories.OCEAN;
        }
        for (Map.Entry<Class<?>, BiomeCategories> entry : rwgClassMap.entrySet()) {
            if (!entry.getKey().isInstance(biome)) continue;
            return entry.getValue();
        }
        return null;
    }
}

