/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;

public class AngelicaRenderQueue {
    private static final Thread MAIN_THREAD = Thread.currentThread();
    private static final Queue<Runnable> TASKS = new ConcurrentLinkedQueue<Runnable>();
    private static final Executor EXECUTOR = runnable -> {
        if (Thread.currentThread() == MAIN_THREAD) {
            runnable.run();
        } else {
            TASKS.add(runnable);
            LockSupport.unpark(MAIN_THREAD);
        }
    };
    private static final long WAIT_TIME = TimeUnit.MILLISECONDS.toNanos(50L);

    public static Executor executor() {
        return EXECUTOR;
    }

    public static int processTasks(int max) {
        Runnable r;
        int tasksRun;
        for (tasksRun = 0; tasksRun < max && (r = TASKS.poll()) != null; ++tasksRun) {
            r.run();
        }
        return tasksRun;
    }

    public static int processTasks() {
        return AngelicaRenderQueue.processTasks(Integer.MAX_VALUE);
    }

    public static void managedBlock(BooleanSupplier isDone) {
        while (!isDone.getAsBoolean()) {
            if (AngelicaRenderQueue.processTasks(1) != 0) continue;
            LockSupport.parkNanos(WAIT_TIME);
        }
    }
}

