/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSearchDTO {
    public DimensionalCoord coord;
    public int cellSlot;
    public long itemCount;
    public ForgeDirection forward;
    public ForgeDirection up;
    public String blockName;
    public String itemName;

    public ItemSearchDTO(DimensionalCoord coord, IAEStack items, String blockName, int cellSlot, ForgeDirection forward, ForgeDirection up) {
        this.coord = coord;
        this.cellSlot = cellSlot;
        this.itemCount = items.getStackSize();
        this.itemName = items.getLocalizedName();
        if (this.itemName == null) {
            this.itemName = " ";
        }
        this.blockName = blockName;
        this.forward = forward;
        this.up = up;
    }

    public ItemSearchDTO(DimensionalCoord coord, IAEStack items, String blockName) {
        this(coord, items, blockName, -1, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN);
    }

    public ItemSearchDTO(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("dim", this.coord.dimId);
        data.func_74768_a("x", this.coord.x);
        data.func_74768_a("y", this.coord.y);
        data.func_74768_a("z", this.coord.z);
        data.func_74768_a("cellSlot", this.cellSlot);
        data.func_74772_a("itemCount", this.itemCount);
        data.func_74778_a("blockName", this.blockName);
        data.func_74778_a("itemName", this.itemName);
        data.func_74778_a("forward", this.forward.name());
        data.func_74778_a("up", this.up.name());
    }

    public static void writeListToNBT(NBTTagCompound tag, List<ItemSearchDTO> list) {
        int i = 0;
        for (ItemSearchDTO d : list) {
            NBTTagCompound data = new NBTTagCompound();
            d.writeToNBT(data);
            tag.func_74782_a("pos#" + i, (NBTBase)data);
            ++i;
        }
    }

    public static List<ItemSearchDTO> readAsListFromNBT(NBTTagCompound tag) {
        ArrayList<ItemSearchDTO> list = new ArrayList<ItemSearchDTO>();
        int i = 0;
        while (tag.func_74764_b("pos#" + i)) {
            NBTTagCompound data = tag.func_74775_l("pos#" + i);
            list.add(new ItemSearchDTO(data));
            ++i;
        }
        return list;
    }

    private void readFromNBT(NBTTagCompound data) {
        int dim = data.func_74762_e("dim");
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        this.blockName = data.func_74779_i("blockName");
        this.itemName = data.func_74779_i("itemName");
        this.itemCount = data.func_74763_f("itemCount");
        this.cellSlot = data.func_74762_e("cellSlot");
        this.coord = new DimensionalCoord(x, y, z, dim);
        this.forward = ForgeDirection.valueOf((String)data.func_74779_i("forward"));
        this.up = ForgeDirection.valueOf((String)data.func_74779_i("up"));
    }
}

