/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.config.TerminalFontSize;
import appeng.util.ReadableNumberConverter;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public class StackSizeRenderer {
    public static void drawStackSize(int offsetX, int offsetY, long stackSize, FontRenderer font, TerminalFontSize fontSize) {
        StackSizeRenderer.drawStackSize(offsetX, offsetY, StackSizeRenderer.getToBeRenderedStackSize(stackSize, fontSize), font, fontSize);
    }

    public static void drawStackSize(int offsetX, int offsetY, String customText, FontRenderer font, TerminalFontSize fontSize) {
        float scale = 1.0f;
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        if (fontSize == TerminalFontSize.LARGE && customText.length() > 3) {
            fontSize = TerminalFontSize.DYNAMIC;
        }
        if (fontSize == TerminalFontSize.SMALL) {
            scale = 0.5f;
            shiftX = 2.0f;
            shiftY = 1.0f;
        } else if (fontSize == TerminalFontSize.LARGE) {
            scale = 0.85f;
        } else if (fontSize == TerminalFontSize.DYNAMIC) {
            if (customText.length() == 3) {
                scale = 0.786f;
                shiftX = 0.5f;
            } else if (customText.length() == 4) {
                scale = 0.644f;
                shiftX = 1.0f;
                shiftY = 0.5f;
            } else if (customText.length() > 4) {
                scale = 0.5f;
                shiftX = 2.0f;
                shiftY = 1.0f;
            } else {
                scale = 0.85f;
            }
        }
        if (scale == 1.0f) {
            font.func_78261_a(customText, offsetX + 16 + 1 - font.func_78256_a(customText), offsetY + 16 - 7, 0xFFFFFF);
        } else {
            float inverseScaleFactor = 1.0f / scale;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            int X = (int)(((float)offsetX - shiftX + 16.0f + 1.0f - (float)font.func_78256_a(customText) * scale) * inverseScaleFactor);
            int Y = (int)(((float)offsetY - shiftY + 16.0f - 7.0f * scale) * inverseScaleFactor);
            font.func_78261_a(customText, X, Y, 0xFFFFFF);
            GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)inverseScaleFactor);
        }
    }

    public static String getToBeRenderedStackSize(long originalSize, TerminalFontSize fontSize) {
        if (fontSize == TerminalFontSize.LARGE) {
            return ReadableNumberConverter.INSTANCE.toSlimReadableForm(originalSize);
        }
        return ReadableNumberConverter.INSTANCE.toWideReadableForm(originalSize);
    }
}

