/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.stats;

import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.stats.AchievementCraftingHandler;
import appeng.core.stats.AchievementHierarchy;
import appeng.core.stats.AchievementPickupHandler;
import appeng.core.stats.Achievements;
import appeng.core.stats.PlayerDifferentiator;
import appeng.core.stats.Stats;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.util.ArrayList;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;

public class PlayerStatsRegistration {
    private final EventBus bus;
    private final boolean isAchievementFeatureEnabled;

    public PlayerStatsRegistration(EventBus bus, AEConfig config) {
        this.bus = bus;
        this.isAchievementFeatureEnabled = config.isFeatureEnabled(AEFeature.Achievements);
    }

    public void registerAchievementHandlers() {
        if (this.isAchievementFeatureEnabled) {
            PlayerDifferentiator differentiator = new PlayerDifferentiator();
            AchievementCraftingHandler craftingHandler = new AchievementCraftingHandler(differentiator);
            AchievementPickupHandler pickupHandler = new AchievementPickupHandler(differentiator);
            this.bus.register((Object)craftingHandler);
            this.bus.register((Object)pickupHandler);
        }
    }

    public void registerAchievements() {
        if (this.isAchievementFeatureEnabled) {
            AchievementHierarchy hierarchy = new AchievementHierarchy();
            hierarchy.registerAchievementHierarchy();
            for (Stats s : Stats.values()) {
                s.getStat();
            }
            ArrayList<Achievement> list = new ArrayList<Achievement>();
            for (Achievements a : Achievements.values()) {
                Achievement ach = a.getAchievement();
                if (ach == null) continue;
                list.add(ach);
            }
            AchievementPage ae2AchievementPage = new AchievementPage("Applied Energistics 2", list.toArray(new Achievement[0]));
            AchievementPage.registerAchievementPage((AchievementPage)ae2AchievementPage);
        }
    }
}

