/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;

public class ConfigDumper {
    public static void dumpConfigIfEnabled(Configuration config, String modid) {
        boolean enabled = Boolean.parseBoolean(System.getProperty(modid + ".configDumper.enabled", "false"));
        if (enabled) {
            ConfigDumper.dumpConfig(config, modid);
        }
    }

    public static void dumpConfig(Configuration config, String modid) {
        File outFile = new File(Launch.minecraftHome, "config-export-" + config.getConfigFile().getName() + ".md");
        try (FileWriter fw = new FileWriter(outFile);){
            for (String category : config.getCategoryNames()) {
                String out = "";
                ConfigCategory cat = config.getCategory(category);
                String catName = cat.getQualifiedName();
                String catBaseName = cat.getName();
                int level = StringUtils.countMatches((CharSequence)catName, (CharSequence)".");
                if (catName.startsWith("_")) continue;
                String catComment = StringUtils.defaultString((String)cat.getComment());
                if (cat.containsKey("_enabled")) {
                    catComment = cat.get((String)"_enabled").comment;
                }
                out = out + ConfigDumper.createEntry(level, catBaseName, ConfigDumper.commentToMarkdown(catComment));
                for (Property prop : cat.getValues().values()) {
                    if (prop.getName().startsWith("_")) continue;
                    out = out + ConfigDumper.createEntry(level + 1, prop.getName(), ConfigDumper.commentToMarkdown(prop.comment));
                }
                fw.write(out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String createEntry(int level, String title, String body) {
        if (level == 0) {
            return "\n# " + title + "\n" + body.replaceAll("\\n\\*", "\n> *") + "\n";
        }
        return ConfigDumper.createIndent(level - 1) + "* **" + title + "**<br>" + body.replaceAll("\n\n", "<br>") + "\n";
    }

    private static String createIndent(int level) {
        return level == 0 ? "" : String.format("%" + level * 4 + "c", Character.valueOf(' '));
    }

    private static String commentToMarkdown(String comment) {
        String outText = "";
        boolean backticksBetwixt = false;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            String outChar = String.valueOf(c);
            if (c == '`') {
                boolean bl = backticksBetwixt = !backticksBetwixt;
            }
            if (c == '<' && !backticksBetwixt) {
                outChar = "&lt;";
            }
            outText = outText + outChar;
        }
        return outText.replaceAll("\n", "\n\n");
    }
}

