/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat;

import com.falsepattern.rple.api.common.color.DefaultColor;
import com.falsepattern.rple.api.common.colorizer.RPLEBlockColorRegistry;
import com.falsepattern.rple.api.common.event.BlockColorRegistrationEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.recipes.ModRecipes;
import net.minecraft.block.Block;

public class CompatRPLEEventHandler {
    private static final CompatRPLEEventHandler instance = new CompatRPLEEventHandler();

    public static void registerRPLECompat() {
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    @SubscribeEvent
    public void kolorsLol(BlockColorRegistrationEvent event) {
        RPLEBlockColorRegistry registry = event.registry();
        this.colorize(registry, ModBlocks.SEA_LANTERN.get(), 2815);
        this.colorize(registry, ModBlocks.END_ROD.get(), 4015);
        this.colorize(registry, ModBlocks.MAGMA.get(), 1296);
        this.colorize(registry, ModBlocks.BEACON.get(), 3276);
        this.colorize(registry, ModBlocks.DEEPSLATE_LIT_REDSTONE_ORE.get(), 1297);
        this.colorize(registry, ModBlocks.LANTERN.get(), 4037);
        this.colorize(registry, ModBlocks.SOUL_LANTERN.get(), 1178);
        this.colorize(registry, ModBlocks.SOUL_TORCH.get(), 1178);
        this.colorize(registry, ModBlocks.SHROOMLIGHT.get(), 4040);
        this.colorize(registry, ModBlocks.LIT_BLAST_FURNACE.get(), 3530);
        this.colorize(registry, ModBlocks.LIT_SMOKER.get(), 3530);
        this.registerAmethystColor(registry, 0, 257);
        this.registerAmethystColor(registry, 1, 530);
        this.registerAmethystColor(registry, 2, 804);
        this.registerAmethystColor(registry, 3, 1077);
        this.registerBulbColor(registry, 0, 4040);
        this.registerBulbColor(registry, 1, 3239);
        this.registerBulbColor(registry, 2, 2147);
        this.registerBulbColor(registry, 3, 1091);
        this.transparency(registry, ModBlocks.SLIME.get(), DefaultColor.LIME.rgb16());
        this.transparency(registry, ModBlocks.HONEY_BLOCK.get(), 4023);
    }

    private void registerAmethystColor(RPLEBlockColorRegistry registry, int clusterSize, int color) {
        Block cluster = clusterSize < 2 ? ModBlocks.AMETHYST_CLUSTER_1.get() : ModBlocks.AMETHYST_CLUSTER_2.get();
        boolean secondHalf = clusterSize % 2 == 0;
        for (int i = secondHalf ? 0 : 6; i < (secondHalf ? 6 : 12); ++i) {
            this.colorize(registry, cluster, i, color);
        }
    }

    private void registerBulbColor(RPLEBlockColorRegistry registry, int level, int color) {
        this.colorize(registry, ModBlocks.COPPER_BULB.get(), level + 4, color);
        this.colorize(registry, ModBlocks.COPPER_BULB.get(), level + 12, color);
        this.colorize(registry, ModBlocks.POWERED_COPPER_BULB.get(), level + 4, color);
        this.colorize(registry, ModBlocks.POWERED_COPPER_BULB.get(), level + 12, color);
    }

    private void colorize(RPLEBlockColorRegistry registry, Block block, int rgb16) {
        if (ModRecipes.validateItems(block)) {
            registry.colorizeBlock(block).brightness(rgb16).apply();
        }
    }

    private void colorize(RPLEBlockColorRegistry registry, Block block, int meta, int rgb16) {
        if (ModRecipes.validateItems(block)) {
            registry.colorizeBlock(block, meta).brightness(rgb16).apply();
        }
    }

    private void transparency(RPLEBlockColorRegistry registry, Block block, int rgb16) {
        if (ModRecipes.validateItems(block)) {
            registry.colorizeBlock(block).translucency(rgb16).apply();
        }
    }

    private void transparency(RPLEBlockColorRegistry registry, Block block, int meta, int rgb16) {
        if (ModRecipes.validateItems(block)) {
            registry.colorizeBlock(block, meta).translucency(rgb16).apply();
        }
    }
}

