/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import com.google.common.collect.Maps;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.DeepslateOreRegistry;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.world.EtFuturumWorldGenerator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.apache.commons.lang3.ArrayUtils;

public class EtFuturumLateWorldGenerator
extends EtFuturumWorldGenerator {
    public static final EtFuturumLateWorldGenerator INSTANCE = new EtFuturumLateWorldGenerator();
    public static final Map<Integer, Map<Long, List<Integer>>> deepslateRedoCache = Maps.newConcurrentMap();
    public static boolean stopRecording;

    protected EtFuturumLateWorldGenerator() {
        if (ModBlocks.DEEPSLATE.isEnabled()) {
            if (ConfigWorld.deepslateReplacesDirt) {
                DeepslateOreRegistry.addOre(Blocks.field_150346_d, ModBlocks.DEEPSLATE.get());
            }
            if (ConfigTweaks.deepslateReplacesCobblestone) {
                DeepslateOreRegistry.addOre(Blocks.field_150347_e, ModBlocks.COBBLED_DEEPSLATE.get());
            }
        }
    }

    @Override
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = null;
        if (this.doesChunkSupportLayerDeepslate(chunkGenerator, world.field_73011_w.field_76574_g)) {
            stopRecording = true;
            Map<Long, List<Integer>> map = deepslateRedoCache.remove(world.field_73011_w.field_76574_g);
            if (map != null) {
                for (Map.Entry<Long, List<Integer>> set : map.entrySet()) {
                    List<Integer> posSet = set.getValue();
                    if (posSet == null) continue;
                    long packedChunkCoords = set.getKey();
                    int redoX = (int)packedChunkCoords;
                    int redoZ = (int)(packedChunkCoords >> 32);
                    Chunk cachedChunk = world.func_72964_e(redoX, redoZ);
                    for (int pos : posSet) {
                        byte posX = (byte)(pos >> 12);
                        short posY = (short)(pos >> 4 & 0xFF);
                        byte posZ = (byte)(pos & 0xF);
                        ExtendedBlockStorage array = cachedChunk.func_76587_i()[posY >> 4];
                        if (array == null) continue;
                        this.replaceBlockInChunk(cachedChunk.field_76637_e, array.func_150819_a((int)posX, posY & 0xF, (int)posZ), posX, posZ, (redoX << 4) + posX, posY, (redoZ << 4) + posZ, array);
                    }
                }
            }
            chunk = world.func_72964_e(chunkX, chunkZ);
            this.doDeepslateGen(chunk);
            stopRecording = false;
        }
        if (ModBlocks.COARSE_DIRT.isEnabled() && ConfigWorld.enableCoarseDirtReplacement) {
            if (chunk == null) {
                chunk = world.func_72964_e(chunkX, chunkZ);
            }
            this.doCoarseDirtGen(chunk);
        }
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c || world.func_72912_H().func_82571_y().contains("decoration") && world.field_73011_w instanceof WorldProviderSurface) {
            if (ModBlocks.DEEPSLATE.isEnabled() && ConfigWorld.deepslateGenerationMode == 1) {
                this.generateOre(this.deepslateBlobGen, world, rand, chunkX, chunkZ, 1.0f, 6, ConfigWorld.deepslateMaxY);
            }
            if (ModBlocks.TUFF.isEnabled()) {
                this.generateOre(this.tuffGen, world, rand, chunkX, chunkZ, 1.0f, 6, ConfigWorld.deepslateMaxY);
            }
            if (ModBlocks.STONE.isEnabled() && ConfigWorld.maxStonesPerCluster > 0) {
                for (WorldGenMinable stoneGenerator : this.stoneGen) {
                    for (int i = 0; i < 10; ++i) {
                        this.generateOre(stoneGenerator, world, rand, chunkX, chunkZ, 1.0f, 0, 80);
                    }
                }
            }
        }
    }

    private void doCoarseDirtGen(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < chunk.func_76611_b(x, z); ++y) {
                    ExtendedBlockStorage array = chunk.func_76587_i()[y >> 4];
                    if (array == null || array.func_76665_b(x, y & 0xF, z) != 1 || array.func_150819_a(x, y & 0xF, z) != Blocks.field_150346_d) continue;
                    array.func_150818_a(x, y & 0xF, z, ModBlocks.COARSE_DIRT.get());
                    array.func_76654_b(x, y & 0xF, z, 0);
                }
            }
        }
    }

    private void doDeepslateGen(Chunk chunk) {
        int chunkMultiplierX = chunk.field_76635_g << 4;
        int chunkMultiplierZ = chunk.field_76647_h << 4;
        boolean shouldDimBeJustDeepslate = ArrayUtils.contains((int[])ConfigWorld.replaceAllStoneWithDeepslateDimensionWhitelist, (int)chunk.field_76637_e.field_73011_w.field_76574_g);
        int replaceUnderY = shouldDimBeJustDeepslate ? chunk.field_76637_e.func_72940_L() : ConfigWorld.deepslateMaxY;
        for (int y = 0; y <= Math.min(replaceUnderY, chunk.field_76637_e.func_72800_K()); ++y) {
            ExtendedBlockStorage array = chunk.func_76587_i()[y >> 4];
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (ConfigWorld.deepslateMaxY < 255 && !shouldDimBeJustDeepslate && y >= ConfigWorld.deepslateMaxY - 4 && y > ConfigWorld.deepslateMaxY - chunk.field_76637_e.field_73012_v.nextInt(4)) continue;
                    int worldX = x + chunkMultiplierX;
                    int worldZ = z + chunkMultiplierZ;
                    if (array == null) continue;
                    this.replaceBlockInChunk(chunk.field_76637_e, array.func_150819_a(x, y & 0xF, z), x, z, worldX, y, worldZ, array);
                }
            }
        }
    }

    private void replaceBlockInChunk(World world, Block block, int x, int z, int worldX, int worldY, int worldZ, ExtendedBlockStorage array) {
        if ((ConfigWorld.deepslateReplacesStones || block != ModBlocks.STONE.get()) && block.func_149688_o() != Material.field_151579_a && block != ModBlocks.TUFF.get()) {
            if (block.isReplaceableOreGen(world, worldX, worldY, worldZ, Blocks.field_150348_b)) {
                array.func_150818_a(x, worldY & 0xF, z, ModBlocks.DEEPSLATE.get());
                array.func_76654_b(x, worldY & 0xF, z, 0);
                return;
            }
            RegistryMapping<Block> mapping = DeepslateOreRegistry.getOre(block, array.func_76665_b(x, worldY & 0xF, z));
            if (mapping != null) {
                array.func_150818_a(x, worldY & 0xF, z, mapping.getObject());
                array.func_76654_b(x, worldY & 0xF, z, mapping.getMeta());
            }
        }
    }

    private boolean doesChunkSupportLayerDeepslate(IChunkProvider provider, int dimId) {
        if (ModBlocks.DEEPSLATE.isEnabled() && ConfigWorld.deepslateGenerationMode == 0 && ConfigWorld.deepslateMaxY > 0) {
            return !this.isFlatWorld(provider) && ArrayUtils.contains((int[])ConfigWorld.deepslateLayerDimensionBlacklist, (int)dimId) == ConfigWorld.deepslateLayerDimensionBlacklistAsWhitelist;
        }
        return false;
    }
}

