/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.gendustry.config.loader;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.bdew.gendustry.Gendustry$;
import net.bdew.gendustry.api.IConfigLoader;
import net.bdew.gendustry.config.loader.Loader;
import net.bdew.lib.Misc$;
import net.bdew.lib.recipes.RecipeLoader;
import net.bdew.lib.recipes.RecipesHelper$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TuningLoader$
implements IConfigLoader {
    public static final TuningLoader$ MODULE$;
    private final Loader loader;

    static {
        new TuningLoader$();
    }

    public Loader loader() {
        return this.loader;
    }

    public void loadDelayed() {
        this.loader().processRecipeStatements();
    }

    public void loadConfigFiles() {
        if (!Gendustry$.MODULE$.configDir().exists()) {
            Gendustry$.MODULE$.configDir().mkdir();
            String nl = System.getProperty("line.separator");
            FileWriter f = new FileWriter(new File(Gendustry$.MODULE$.configDir(), "readme.txt"));
            f.write(new StringBuilder().append((Object)"Any .cfg files in this directory will be loaded after the internal configuration, in alphabetic order").append((Object)nl).toString());
            f.write(new StringBuilder().append((Object)"Files in 'overrides' directory with matching names cab be used to override internal configuration").append((Object)nl).toString());
            f.close();
        }
        RecipesHelper$.MODULE$.loadConfigs("Gendustry", "/assets/gendustry/config/files.lst", Gendustry$.MODULE$.configDir(), "/assets/gendustry/config/", (RecipeLoader)this.loader());
    }

    @Override
    public boolean loadConfig(Reader reader) {
        boolean bl;
        Gendustry$.MODULE$.logInfo("Loading config submitted by mod %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getActiveModId()}));
        try {
            this.loader().load(reader);
            bl = true;
        }
        catch (Throwable throwable) {
            Gendustry$.MODULE$.logErrorException("Error loading config submitted by mod %s", throwable, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getActiveModId()}));
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean loadConfig(File file) {
        boolean bl;
        Gendustry$.MODULE$.logInfo("Loading config %s submitted by mod %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath(), Misc$.MODULE$.getActiveModId()}));
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)Misc$.MODULE$.withAutoClose((AutoCloseable)new FileReader(file), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileReader reader) {
                    TuningLoader$.MODULE$.loader().load(reader);
                    return true;
                }
            }));
        }
        catch (Throwable throwable) {
            Gendustry$.MODULE$.logErrorException("Error loading config %s submitted by mod %s", throwable, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath(), Misc$.MODULE$.getActiveModId()}));
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean loadConfig(String resourceName) {
        boolean bl;
        URL res = this.getClass().getResource(resourceName);
        if (res == null) {
            Gendustry$.MODULE$.logError("Unable to load resource %s submitted by mod %s - resource not found", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceName, Misc$.MODULE$.getActiveModId()}));
            return false;
        }
        Gendustry$.MODULE$.logInfo("Loading config %s submitted by mod %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.toString(), Misc$.MODULE$.getActiveModId()}));
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)Misc$.MODULE$.withAutoClose((AutoCloseable)this.getClass().getResourceAsStream(resourceName), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(InputStream stream) {
                    TuningLoader$.MODULE$.loader().load(new InputStreamReader(stream));
                    return true;
                }
            }));
        }
        catch (Throwable throwable) {
            Gendustry$.MODULE$.logErrorException("Error loading config %s submitted by mod %s", throwable, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getResource(resourceName).toString(), Misc$.MODULE$.getActiveModId()}));
            bl = false;
        }
        return bl;
    }

    private TuningLoader$() {
        MODULE$ = this;
        this.loader = new Loader();
    }
}

