/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.worldgen;

import bartworks.common.configs.Configuration;
import gregtech.api.GregTechAPI;
import java.util.Random;
import net.minecraft.block.Block;

public class BWWorldGenUtil {
    public static final Block GT_TILES = GregTechAPI.sBlockMachines;

    private BWWorldGenUtil() {
    }

    public static int getGenerator(Random rand, int tier) {
        int meta;
        switch (tier) {
            case 0: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.highPressureSteam.generators.length);
                meta = Configuration.rossRuinMetas.highPressureSteam.generators[randomIndex];
                break;
            }
            case 1: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.lv.generators.length);
                meta = Configuration.rossRuinMetas.lv.generators[randomIndex];
                break;
            }
            case 2: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.mv.generators.length);
                meta = Configuration.rossRuinMetas.mv.generators[randomIndex];
                break;
            }
            case 3: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.hv.generators.length);
                meta = Configuration.rossRuinMetas.hv.generators[randomIndex];
                break;
            }
            case 4: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.ev.generators.length);
                meta = Configuration.rossRuinMetas.ev.generators[randomIndex];
                break;
            }
            default: {
                throw new IllegalStateException("tier " + tier + " is not allowed for Ross Ruins.");
            }
        }
        if (GregTechAPI.METATILEENTITIES[meta] == null) {
            throw new IllegalStateException("MetaID " + meta + " is null, please remove it from the Ross Ruin config");
        }
        return meta;
    }

    public static int getBuffer(Random rand, int tier) {
        int meta;
        switch (tier) {
            case 0: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.highPressureSteam.buffers.length);
                meta = Configuration.rossRuinMetas.highPressureSteam.buffers[randomIndex];
                break;
            }
            case 1: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.lv.buffers.length);
                meta = Configuration.rossRuinMetas.lv.buffers[randomIndex];
                break;
            }
            case 2: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.mv.buffers.length);
                meta = Configuration.rossRuinMetas.mv.buffers[randomIndex];
                break;
            }
            case 3: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.hv.buffers.length);
                meta = Configuration.rossRuinMetas.hv.buffers[randomIndex];
                break;
            }
            case 4: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.ev.buffers.length);
                meta = Configuration.rossRuinMetas.ev.buffers[randomIndex];
                break;
            }
            default: {
                throw new IllegalStateException("tier " + tier + " is not allowed for Ross Ruins.");
            }
        }
        if (GregTechAPI.METATILEENTITIES[meta] == null) {
            throw new IllegalStateException("MetaID " + meta + " is null, please remove it from the Ross Ruin config");
        }
        return meta;
    }

    public static int getCable(Random rand, int tier) {
        int meta;
        switch (tier) {
            case 0: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.highPressureSteam.cables.length);
                meta = Configuration.rossRuinMetas.highPressureSteam.cables[randomIndex];
                break;
            }
            case 1: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.lv.cables.length);
                meta = Configuration.rossRuinMetas.lv.cables[randomIndex];
                break;
            }
            case 2: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.mv.cables.length);
                meta = Configuration.rossRuinMetas.mv.cables[randomIndex];
                break;
            }
            case 3: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.hv.cables.length);
                meta = Configuration.rossRuinMetas.hv.cables[randomIndex];
                break;
            }
            case 4: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.ev.cables.length);
                meta = Configuration.rossRuinMetas.ev.cables[randomIndex];
                break;
            }
            default: {
                throw new IllegalStateException("tier " + tier + " is not allowed for Ross Ruins.");
            }
        }
        if (GregTechAPI.METATILEENTITIES[meta] == null) {
            throw new IllegalStateException("MetaID " + meta + " is null, please remove it from the Ross Ruin config");
        }
        return meta;
    }

    public static int getMachine(Random rand, int tier) {
        int meta;
        switch (tier) {
            case 0: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.highPressureSteam.machines.length);
                meta = Configuration.rossRuinMetas.highPressureSteam.machines[randomIndex];
                break;
            }
            case 1: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.lv.machines.length);
                meta = Configuration.rossRuinMetas.lv.machines[randomIndex];
                break;
            }
            case 2: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.mv.machines.length);
                meta = Configuration.rossRuinMetas.mv.machines[randomIndex];
                break;
            }
            case 3: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.hv.machines.length);
                meta = Configuration.rossRuinMetas.hv.machines[randomIndex];
                break;
            }
            case 4: {
                int randomIndex = rand.nextInt(Configuration.rossRuinMetas.ev.machines.length);
                meta = Configuration.rossRuinMetas.ev.machines[randomIndex];
                break;
            }
            default: {
                throw new IllegalStateException("tier " + tier + " is not allowed for Ross Ruins.");
            }
        }
        if (GregTechAPI.METATILEENTITIES[meta] == null) {
            throw new IllegalStateException("MetaID " + meta + " is null, please remove it from the Ross Ruin config");
        }
        return meta;
    }
}

