/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.casing;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.structure.IStructureInstance;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ICasing
extends ImmutableBlockMeta {
    public int getTextureId();

    default public <T> int getTextureId(T t, CasingElementContext<T> context) {
        return this.getTextureId();
    }

    default public ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId(this.getTextureId());
    }

    default public <T> ITexture getCasingTexture(T t, CasingElementContext<T> context) {
        return Textures.BlockIcons.getCasingTextureForId(this.getTextureId(t, context));
    }

    public boolean isTiered();

    default public ItemStack toStack(int amount) {
        Item item = Item.func_150898_a((Block)this.getBlock());
        if (item == null) {
            throw new NullPointerException("Block " + this.getBlock() + " was not registered, causing it to not have an item (casing: " + this + ")");
        }
        return new ItemStack(this.getBlock(), 1, this.getBlockMeta());
    }

    default public String getLocalizedName() {
        return this.toStack(1).func_82833_r();
    }

    default public <T> IStructureElement<T> asElement(CasingElementContext<T> context) {
        return StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)this.getBlock(), (int)this.getBlockMeta()));
    }

    default public <T> IStructureElement<T> asElement() {
        return StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)this.getBlock(), (int)this.getBlockMeta()));
    }

    public static ICasing ofBlock(final ImmutableBlockMeta block) {
        return new ICasing(){

            @Override
            public int getTextureId() {
                return -1;
            }

            @Override
            public ITexture getCasingTexture() {
                return TextureFactory.builder().setFromBlock(this.getBlock(), this.getBlockMeta()).build();
            }

            @NotNull
            public Block getBlock() {
                return block.getBlock();
            }

            public int getBlockMeta() {
                return block.getBlockMeta();
            }

            @Override
            public boolean isTiered() {
                return false;
            }
        };
    }

    public static interface CasingElementContext<T> {
        public ICasingGroup getGroup();

        public IStructureInstance<T> getInstance(T var1);
    }
}

