/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketChat;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Localized;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public enum ChatMessage {
    PowerfailsCleared(ChatMessage.localized("GT5U.gui.chat.powerfail.cleared")),
    PowerfailsClearedDim(ChatMessage.localized("GT5U.gui.chat.powerfail.cleared-dim")),
    PowerfailsListNone(ChatMessage.localized("GT5U.gui.chat.powerfail.list.none")),
    PowerfailsListHeader(ChatMessage.localized("GT5U.gui.chat.powerfail.list.uncleared-header")),
    PowerfailsListEntry(ChatMessage.localized("GT5U.gui.chat.powerfail.list.entry")),
    PowerfailsListTruncated(ChatMessage.localized("GT5U.gui.chat.powerfail.list.truncated")),
    PowerfailGreeting(ChatMessage.plural("GT5U.gui.chat.powerfail.login", "GT5U.gui.chat.powerfail.login.plural", 0)),
    PowerfailCommandHint(ChatMessage.localized("GT5U.gui.chat.powerfail.hint")),
    PowerfailRenderShown(ChatMessage.localized("GT5U.gui.chat.powerfail.shown")),
    PowerfailRenderHidden(ChatMessage.localized("GT5U.gui.chat.powerfail.hidden")),
    PowerfailWaypoint(ChatMessage.plural("GT5U.gui.chat.powerfail.waypoint", "GT5U.gui.chat.powerfail.waypoint.plural", 1)),
    PowerfailDescription(ChatMessage.plural("GT5U.gui.chat.powerfail", "GT5U.gui.chat.powerfail.plural", 3)),
    Dimension(args -> GTUtility.getDimensionName((Integer)args[0]));

    private final Localizer localizer;

    private ChatMessage(Localizer localizer) {
        this.localizer = localizer;
    }

    public String localize(Object ... args) {
        return "\u00a7s" + this.localizer.localize(args) + "\u00a7t";
    }

    public void send(EntityPlayer player, Object ... args) {
        if (GTUtility.isServer()) {
            GTValues.NW.sendToPlayer(new GTPacketChat(this, args), (EntityPlayerMP)player);
        } else {
            GTUtility.sendChatToPlayer(player, this.localize(args));
        }
    }

    private static Localizer localized(String key) {
        return args -> GTUtility.translate(key, Localized.processArgs(args));
    }

    private static Localizer plural(String singular, String plural, int pluralIndex) {
        return args -> {
            int value;
            Object patt2994$temp = args[pluralIndex];
            if (patt2994$temp instanceof Integer) {
                Integer i = (Integer)patt2994$temp;
                value = i;
            } else {
                StringBuilder sb = new StringBuilder();
                char[] charArray = args[pluralIndex].toString().toCharArray();
                int charArrayLength = charArray.length;
                for (int i = 0; i < charArrayLength; ++i) {
                    char c = charArray[i];
                    if (c == '\u00a7') {
                        ++i;
                        continue;
                    }
                    if (c < '0' || c > '9') continue;
                    sb.append(c);
                }
                try {
                    value = Integer.parseInt(sb.toString());
                }
                catch (NumberFormatException e) {
                    GTMod.GT_FML_LOGGER.warn("Could not parse ChatMessage value to check if the index is plural. Lang Key (Singular)={}, Index={}, Value={}", new Object[]{singular, pluralIndex, args[pluralIndex], new Exception()});
                    value = 2;
                }
            }
            String key = value == 1 ? singular : plural;
            return GTUtility.translate(key, Localized.processArgs(args));
        };
    }

    static interface Localizer {
        public String localize(Object[] var1);
    }
}

