/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Materials;
import gregtech.api.util.GTUtility;

public class MaterialStack
implements Cloneable {
    public long mAmount;
    public Materials mMaterial;

    public MaterialStack(Materials aMaterial, long aAmount) {
        this.mMaterial = aMaterial == null ? Materials._NULL : aMaterial;
        this.mAmount = aAmount;
    }

    public MaterialStack copy(long aAmount) {
        return new MaterialStack(this.mMaterial, aAmount);
    }

    public MaterialStack clone() {
        try {
            return (MaterialStack)super.clone();
        }
        catch (Exception e) {
            return new MaterialStack(this.mMaterial, this.mAmount);
        }
    }

    public boolean equals(Object aObject) {
        if (aObject == this) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        if (aObject instanceof Materials) {
            return aObject == this.mMaterial;
        }
        if (aObject instanceof MaterialStack) {
            return ((MaterialStack)aObject).mMaterial == this.mMaterial && (this.mAmount < 0L || ((MaterialStack)aObject).mAmount < 0L || ((MaterialStack)aObject).mAmount == this.mAmount);
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean single) {
        String temp1 = "";
        String temp2 = this.mMaterial.getToolTip(true);
        String temp3 = "";
        String temp4 = "";
        if (this.mAmount > 1L) {
            temp4 = GTUtility.toSubscript(this.mAmount);
        }
        if ((!single || this.mAmount > 1L) && this.isMaterialListComplex(this)) {
            temp1 = "(";
            temp3 = ")";
        }
        return temp1 + temp2 + temp3 + temp4;
    }

    private boolean isMaterialListComplex(MaterialStack materialStack) {
        if (materialStack.mMaterial.mMaterialList.size() > 1) {
            return true;
        }
        if (materialStack.mMaterial.mMaterialList.isEmpty()) {
            return false;
        }
        return this.isMaterialListComplex(materialStack.mMaterial.mMaterialList.get(0));
    }

    public int hashCode() {
        return this.mMaterial.hashCode();
    }
}

