/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.pollution.FurnacePollution;
import gregtech.common.pollution.PollutionConfig;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class PollutionTooltip {
    private static final String PRODUCES_POLLUTION_FORMAT = "GT5U.tooltip.pollution.produces";
    private static final String MULTI_POLLUTION_FORMAT = "GT5U.tooltip.pollution.produces.multiblock";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getTooltip(ItemTooltipEvent event) {
        String simpleName;
        if (event.itemStack == null) {
            return;
        }
        if (PollutionConfig.furnacesPollute) {
            if (GTUtility.areStacksEqual(event.itemStack, new ItemStack(Blocks.field_150460_al))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.FURNACE.getPollution()}));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "blockMachine", 1L, 1))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.IRON_FURNACE.getPollution()}));
            }
            if (Mods.Thaumcraft.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockStoneDevice", 1L, 0))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.ALCHEMICAL_FURNACE.getPollution()}));
            }
            if (Mods.ThaumicBases.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.ThaumicBases.ID, "advAlchFurnace", 1L, 0))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.ADVANCED_ALCHEMICAL_FURNACE.getPollution()}));
            }
            if (Mods.EtFuturumRequiem.isModLoaded() && (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "blast_furnace", 1L, 0)) || GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "smoker", 1L, 0)))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.BLAST_FURNACE.getPollution()}));
            }
            if (Mods.Natura.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Natura.ID, "NetherFurnace", 1L, 0))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.NETHER_FURNACE.getPollution()}));
            }
            if (Mods.TinkerConstruct.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.TinkerConstruct.ID, "FurnaceSlab", 1L, 0))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{FurnacePollution.SLAB_FURNACE.getPollution()}));
            }
        }
        if (Mods.Railcraft.isModLoaded() && PollutionConfig.railcraftPollutes) {
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "machine.beta", 1L, 5)) || GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "machine.beta", 1L, 6))) {
                event.toolTip.add(StatCollector.func_74837_a((String)"GT5U.tooltip.pollution.produces.firebox", (Object[])new Object[]{PollutionConfig.fireboxPollutionAmount}));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "cart.bore", 1L, 0))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{PollutionConfig.tunnelBorePollutionAmount}));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "machine.alpha", 1L, 7))) {
                event.toolTip.add(StatCollector.func_74837_a((String)MULTI_POLLUTION_FORMAT, (Object[])new Object[]{PollutionConfig.cokeOvenPollutionAmount}));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "machine.alpha", 1L, 12))) {
                event.toolTip.add(StatCollector.func_74837_a((String)MULTI_POLLUTION_FORMAT, (Object[])new Object[]{PollutionConfig.advancedCokeOvenPollutionAmount}));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem(Mods.Railcraft.ID, "machine.beta", 1L, 7))) {
                event.toolTip.add(StatCollector.func_74837_a((String)PRODUCES_POLLUTION_FORMAT, (Object[])new Object[]{PollutionConfig.hobbyistEnginePollutionAmount}));
            }
        }
        if (Mods.GalacticraftCore.isModLoaded() && PollutionConfig.rocketsPollute && event.itemStack.func_77973_b() != null && (simpleName = event.itemStack.func_77973_b().getClass().getSimpleName()).contains("Rocket")) {
            for (char d : simpleName.toCharArray()) {
                if (!Character.isDigit(d)) continue;
                int tier = Character.getNumericValue(d);
                event.toolTip.add(StatCollector.func_74837_a((String)"GT5U.tooltip.pollution.produces.rocket.ignited", (Object[])new Object[]{PollutionConfig.rocketPollutionAmount * tier / 100}));
                event.toolTip.add(StatCollector.func_74837_a((String)"GT5U.tooltip.pollution.produces.rocket.flying", (Object[])new Object[]{PollutionConfig.rocketPollutionAmount * tier}));
                break;
            }
        }
    }
}

