/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.api.enums.Textures;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.common.render.GTRenderUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class InfinityMetaItemRenderer
implements IItemRenderer {
    public Random rand = new Random();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        Item item2 = item.func_77973_b();
        if (item2 instanceof MetaGeneratedItem) {
            MetaGeneratedItem mgItem = (MetaGeneratedItem)item2;
            IIcon[] icons = mgItem.mIconList[item.func_77960_j() - mgItem.mOffset];
            if (icons != null && icons.length > 0 && icons[0] != null) {
                if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                    this.renderHalo();
                    this.renderPulse(icons[0], icons[0]);
                }
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GTRenderUtil.renderItem(type, icons[0]);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderHalo() {
        GL11.glPushMatrix();
        IIcon halo = Textures.ItemIcons.HALO.getIcon();
        int spread = 10;
        int haloAlpha = -16777216;
        if (halo == null) {
            return;
        }
        Tessellator t = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)0.078431375f, (float)0.078431375f, (float)0.078431375f, (float)((float)(haloAlpha >> 24 & 0xFF) / 255.0f));
        t.func_78382_b();
        t.func_78374_a((double)(-spread), (double)(-spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94206_g());
        t.func_78374_a((double)(-spread), (double)(16 + spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94210_h());
        t.func_78374_a((double)(16 + spread), (double)(16 + spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94210_h());
        t.func_78374_a((double)(16 + spread), (double)(-spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94206_g());
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderPulse(IIcon ... icons) {
        Tessellator t = Tessellator.field_78398_a;
        double random = this.rand.nextGaussian();
        double scale = random * 0.15 + 0.95;
        double offset = (1.0 - scale) / 2.0;
        for (IIcon icon : icons) {
            if (icon == null) continue;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glTranslated((double)(offset * 16.0), (double)(offset * 16.0), (double)1.0);
            GL11.glScaled((double)scale, (double)scale, (double)1.0);
            t.func_78382_b();
            t.func_78369_a(1.0f, 1.0f, 1.0f, 0.6f);
            t.func_78374_a(0.0 - offset, 0.0 - offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            t.func_78374_a(0.0 - offset, 16.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 0.0 - offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

