/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTELargeTurbineSteam
extends MTELargeTurbine {
    private int excessWater;
    private boolean achievement = false;

    public MTELargeTurbineSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineSteam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][57];
        return iTextureArray;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Steam Turbine, LST").addInfo("Needs a Turbine, place inside controller").addInfo("Outputs Distilled Water as well as producing power").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Turbine Casing", 8, 31, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Steam, Side centered", 2).addOutputHatch("Distilled Water, Side centered", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineSteam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 9;
    }

    @Override
    public int getCasingTextureIndex() {
        return 57;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    private int condenseSteam(int steam) {
        this.excessWater += steam;
        int water = this.excessWater / 160;
        this.excessWater %= 160;
        return water;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        this.realOptFlow = this.looseFit ? (double)turbine.getOptimalLooseSteamFlow() : (double)turbine.getOptimalSteamFlow();
        int remainingFlow = GTUtility.safeInt((long)(this.realOptFlow * (double)(0.5f * (float)turbine.getOverflowEfficiency() + 1.0f)));
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (GTModHandler.isAnySteam(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                GTMod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "muchsteam");
                this.achievement = true;
                continue;
            }
            if (!GTModHandler.isSuperHeatedSteam(aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        int waterToOutput = this.condenseSteam(totalFlow);
        this.addOutput(GTModHandler.getDistilledWater(waterToOutput));
        if (totalFlow == GTUtility.safeInt((long)this.realOptFlow)) {
            tEU = GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()) * 0.5f));
        } else {
            float efficiency = this.getOverflowEfficiency(totalFlow, GTUtility.safeInt((long)this.realOptFlow), this.overflowMultiplier);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()) * 0.5f)));
        }
        if ((long)tEU > this.getMaximumOutput()) {
            tEU = GTUtility.safeInt(this.getMaximumOutput());
        }
        return tEU;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier + 1)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && XSTR.XSTR_INSTANCE.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String[] getInfoData() {
        return super.getInfoData();
    }
}

