/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.util.CommonValues;

public class MTEHatchCreativeData
extends MTEHatchDataConnector<QuantumDataPacket> {
    private long production = Long.MAX_VALUE;

    public MTEHatchCreativeData(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.data.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.data.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.data.desc.2")});
    }

    public MTEHatchCreativeData(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchCreativeData(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("computation", this.production);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.production = aNBT.func_74763_f("computation");
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    protected QuantumDataPacket loadPacketFromNBT(NBTTagCompound nbt) {
        return new QuantumDataPacket(nbt);
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return this.isOutputFacing(side);
    }

    @Override
    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        IConnectsToDataPipe next;
        IConnectsToDataPipe current = this;
        MTEHatchCreativeData source = this;
        int range = 0;
        while ((next = current.getNext(source)) != null && range++ < 1000) {
            if (next instanceof MTEHatchDataInput) {
                ((MTEHatchDataInput)next).setContents((QuantumDataPacket)this.q);
                break;
            }
            source = current;
            current = next;
        }
        this.q = null;
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        byte color = base.getColorization();
        if (color < 0) {
            return null;
        }
        IGregTechTileEntity next = base.getIGregTechTileEntityAtSide(base.getFrontFacing());
        if (next == null) {
            return null;
        }
        IMetaTileEntity meta = next.getMetaTileEntity();
        if (meta instanceof MTEPipeData) {
            ((MTEPipeData)meta).markUsed();
            return (IConnectsToDataPipe)((Object)meta);
        }
        if (meta instanceof MTEHatchDataInput && ((MTEHatchDataInput)meta).getColorization() == color && ((MTEHatchDataInput)meta).canConnectData(base.getFrontFacing().getOpposite())) {
            return (IConnectsToDataPipe)((Object)meta);
        }
        return null;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && 4L == aTick % 20L) {
            if (aBaseMetaTileEntity.isAllowedToWork()) {
                this.getBaseMetaTileEntity().setActive(true);
                if (this.q == null) {
                    this.q = new QuantumDataPacket(this.production);
                }
                this.moveAround(aBaseMetaTileEntity);
            } else {
                this.q = null;
                this.getBaseMetaTileEntity().setActive(false);
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.openGui(aPlayer);
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        int x = this.getGUIWidth() / 2 - 37;
        int y = this.getGUIHeight() / 5 - 7;
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.computation_hatch.computation", (Object[])new Object[0]).setPos(x, y).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.production = (long)val;
        }).setGetter(() -> this.production).setBounds(1.0, 9.223372036854776E18).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(x, y + 16).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
    }
}

