/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.util;

import gregtech.api.util.GTUtility;
import java.math.BigInteger;
import tectech.util.TTUtility;

public enum MilestoneFormatter {
    NONE,
    COMMA,
    EXPONENT;

    public static final MilestoneFormatter[] VALUES;

    public MilestoneFormatter cycle() {
        MilestoneFormatter milestoneFormatter;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                milestoneFormatter = COMMA;
                break;
            }
            case COMMA: {
                milestoneFormatter = EXPONENT;
                break;
            }
            case EXPONENT: {
                milestoneFormatter = NONE;
            }
        }
        return milestoneFormatter;
    }

    public String format(Number number) {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                string = number.toString();
                break;
            }
            case COMMA: {
                if (number instanceof BigInteger) {
                    BigInteger bi = (BigInteger)number;
                    string = GTUtility.formatNumbers(bi);
                    break;
                }
                string = GTUtility.formatNumbers(number.longValue());
                break;
            }
            case EXPONENT: {
                if (number instanceof BigInteger) {
                    BigInteger bi = (BigInteger)number;
                    if (bi.compareTo(BigInteger.valueOf(1000L)) > 0) {
                        string = TTUtility.toExponentForm(bi);
                        break;
                    }
                    string = bi.toString();
                    break;
                }
                long value = number.longValue();
                if (value > 1000L) {
                    string = TTUtility.toExponentForm(value);
                    break;
                }
                string = Long.toString(value);
                break;
            }
        }
        return string;
    }

    static {
        VALUES = MilestoneFormatter.values();
    }
}

