/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.pipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.HarvestTool;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.pipe.IActivePipe;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.mechanics.pipe.PipeActivityMessage;
import tectech.util.CommonValues;

public class MTEPipeLaser
extends MetaPipeEntity
implements IConnectsToEnergyTunnel,
IActivePipe {
    static Textures.BlockIcons.CustomIcon EMcandy;
    static Textures.BlockIcons.CustomIcon EMCandyActive;
    private static Textures.BlockIcons.CustomIcon EMpipe;
    public byte connectionCount = 0;
    private boolean active;

    public MTEPipeLaser(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0);
    }

    public MTEPipeLaser(String aName) {
        super(aName, 0);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEPipeLaser(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMcandy = new Textures.BlockIcons.CustomIcon("iconsets/EM_CANDY");
        EMCandyActive = new Textures.BlockIcons.CustomIcon("iconsets/EM_CANDY_ACTIVE");
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_LASER");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{TextureFactory.of(EMpipe), TextureFactory.of(this.getActive() ? EMCandyActive : EMcandy, Dyes.getModulation(colorIndex, Dyes.MACHINE_METAL.getRGBA()))};
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    public void updateNeighboringNetworks() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity gregTechTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(side);
            if (gregTechTileEntity == null || !((iMetaTileEntity = gregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeLaser)) continue;
            MTEPipeLaser neighbor = (MTEPipeLaser)iMetaTileEntity;
            neighbor.updateNetwork(true);
        }
    }

    public void updateNetwork(boolean nestedCall) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.active = false;
        this.mConnections = 0;
        this.connectionCount = 0;
        if (aBaseMetaTileEntity.getColorization() < 0) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IConnectsToEnergyTunnel tunnel;
            IGregTechTileEntity gregTechTileEntity;
            IMetaTileEntity iMetaTileEntity;
            IConnectsToEnergyTunnel tunnel2;
            IColoredTileEntity coloredTileEntity;
            byte tColor;
            ForgeDirection oppositeSide = side.getOpposite();
            TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(side);
            if (tTileEntity instanceof IColoredTileEntity && (tColor = (coloredTileEntity = (IColoredTileEntity)tTileEntity).getColorization()) != aBaseMetaTileEntity.getColorization()) continue;
            if (tTileEntity instanceof IConnectsToEnergyTunnel && (tunnel2 = (IConnectsToEnergyTunnel)tTileEntity).canConnect(oppositeSide)) {
                this.mConnections = (byte)(this.mConnections | side.flag);
                this.connectionCount = (byte)(this.connectionCount + 1);
                continue;
            }
            if (!(tTileEntity instanceof IGregTechTileEntity) || !((iMetaTileEntity = (gregTechTileEntity = (IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof IConnectsToEnergyTunnel) || !(tunnel = (IConnectsToEnergyTunnel)((Object)iMetaTileEntity)).canConnect(oppositeSide)) continue;
            this.mConnections = (byte)(this.mConnections | side.flag);
            this.connectionCount = (byte)(this.connectionCount + 1);
        }
        if (!nestedCall) {
            this.updateNeighboringNetworks();
        }
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.updateNetwork(false);
        super.onColorChangeServer(aColor);
    }

    @Override
    public void onBlockDestroyed() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            MTEPipeLaser neighbor;
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity gregTechTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(side);
            if (gregTechTileEntity == null || !((iMetaTileEntity = gregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeLaser) || !(neighbor = (MTEPipeLaser)iMetaTileEntity).isConnectedAtSide(side.getOpposite())) continue;
            neighbor.mConnections = (byte)(neighbor.mConnections & ~side.getOpposite().flag);
            neighbor.connectionCount = (byte)(neighbor.connectionCount - 1);
        }
        super.onBlockDestroyed();
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.updateNetwork(false);
        super.onFirstTick(aBaseMetaTileEntity);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L && TecTech.RANDOM.nextInt(15) == 0) {
                NetworkDispatcher.INSTANCE.sendToAllAround(new PipeActivityMessage.PipeActivityData(this), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GTMod.clientProxy().changeDetected() == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        this.active = nbtTagCompound.func_74767_n("eActive");
    }

    @Override
    public void saveNBTData(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("eActive", this.active);
    }

    @Override
    public boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public byte getTileEntityBaseType() {
        return HarvestTool.WrenchPipeLevel0.toTileEntityBaseType();
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.2"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.3")};
    }

    @Override
    public void setActive(boolean state) {
        if (state != this.active) {
            this.active = state;
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void markUsed() {
        this.active = true;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public float getCollisionThickness() {
        return 0.5f;
    }
}

