/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import net.minecraft.item.ItemStack;

public interface InventoryIterator
extends ListIterator<ImmutableItemStack> {
    public static final InventoryIterator EMPTY = new EmptyInventoryIterator();

    @Override
    default public void set(ImmutableItemStack immutableItemStack) {
        throw new UnsupportedOperationException("Cannot insert items into an InventorySourceIterator");
    }

    @Override
    default public void add(ImmutableItemStack immutableItemStack) {
        throw new UnsupportedOperationException("Cannot insert items into an InventorySourceIterator");
    }

    @Override
    default public void remove() {
        throw new UnsupportedOperationException("Cannot remove items from an InventorySourceIterator via remove(); use extract()");
    }

    public ItemStack extract(int var1, boolean var2);

    @Nonnegative
    public int insert(ImmutableItemStack var1, boolean var2);

    public boolean rewind();

    public static class EmptyInventoryIterator
    implements InventoryIterator {
        @Override
        public ItemStack extract(int amount, boolean force) {
            return null;
        }

        @Override
        public int insert(ImmutableItemStack stack, boolean force) {
            return stack.getStackSize();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ImmutableItemStack next() {
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public ImmutableItemStack previous() {
            return null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public boolean rewind() {
            return false;
        }
    }
}

