/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VBOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import logisticspipes.renderer.newpipe.IRenderable;

public class VBOList
implements IRenderable {
    private final int listID = VBOManager.generateDisplayLists((int)1);
    private boolean isValid = true;
    private long lastUsed = System.currentTimeMillis();
    private boolean isFilled = false;

    @Override
    public int getID() {
        return this.listID;
    }

    @Override
    public void startListCompile() {
        TessellatorManager.startCapturing();
    }

    @Override
    public void stopCompile() {
        VertexBuffer vbo = TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL);
        VBOManager.registerVBO((int)this.listID, (VertexBuffer)vbo);
        this.isFilled = true;
    }

    @Override
    public void render() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        VBOManager.get((int)this.listID).render();
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public boolean check() {
        if (!this.isValid) {
            return true;
        }
        if (this.lastUsed + 60000L < System.currentTimeMillis()) {
            this.isValid = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void close() {
        VertexBuffer buffer = VBOManager.get((int)this.listID);
        buffer.close();
        this.isValid = false;
    }
}

