/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import java.util.List;
import net.minecraft.world.World;

public interface IntegerProperty
extends BlockProperty<Integer> {
    @Override
    default public Integer getValue(World world, int x, int y, int z) {
        return this.getInt(world, x, y, z);
    }

    @Override
    default public void setValue(World world, int x, int y, int z, Integer value) {
        this.setInt(world, x, y, z, value);
    }

    @Override
    default public Integer parse(String text) {
        return Integer.parseInt(text);
    }

    public int getInt(World var1, int var2, int var3, int var4);

    public void setInt(World var1, int var2, int var3, int var4, int var5);

    default public BlockProperty<String> map(final List<String> values) {
        return new BlockProperty<String>(){

            @Override
            public String getName() {
                return IntegerProperty.this.getName();
            }

            @Override
            public String getValue(World world, int x, int y, int z) {
                return (String)MMUtils.getIndexSafe(values, IntegerProperty.this.getInt(world, x, y, z));
            }

            @Override
            public void setValue(World world, int x, int y, int z, String value) {
                IntegerProperty.this.setInt(world, x, y, z, values.indexOf(value));
            }

            @Override
            public String parse(String text) {
                return text;
            }
        };
    }

    public static IntegerProperty meta(final String name, final int mask, final int shift) {
        return new IntegerProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                return (world.func_72805_g(x, y, z) & mask) >> shift;
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                int meta = world.func_72805_g(x, y, z) & ~mask;
                world.func_72921_c(x, y, z, meta |= value << shift & mask, 2);
            }
        };
    }
}

