/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widgets.layout.IExpander;

public class Flow
extends ParentWidget<Flow>
implements ILayoutWidget,
IExpander {
    private final GuiAxis axis;
    private Alignment.MainAxis maa = Alignment.MainAxis.START;
    private Alignment.CrossAxis caa = Alignment.CrossAxis.CENTER;
    private int spaceBetween = 0;
    private boolean collapseDisabledChild = false;

    public static Flow row() {
        return new Flow(GuiAxis.X);
    }

    public static Flow column() {
        return new Flow(GuiAxis.Y);
    }

    public Flow(GuiAxis axis) {
        this.axis = axis;
        this.sizeRel(1.0f, 1.0f);
    }

    @Override
    public void layoutWidgets() {
        if (!this.hasChildren()) {
            return;
        }
        boolean hasSize = this.resizer().isSizeCalculated(this.axis);
        Box padding = this.getArea().getPadding();
        int size = this.getArea().getSize(this.axis) - padding.getTotal(this.axis);
        Alignment.MainAxis maa = this.maa;
        if (!hasSize && maa != Alignment.MainAxis.START) {
            maa = Alignment.MainAxis.START;
        }
        int space = this.spaceBetween;
        int childrenSize = 0;
        int expandedAmount = 0;
        int amount = 0;
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(this.axis)) continue;
            ++amount;
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                childrenSize += widget.getArea().getMargin().getTotal(this.axis);
                continue;
            }
            childrenSize += widget.getArea().requestedSize(this.axis);
        }
        if (amount <= 1 && maa == Alignment.MainAxis.SPACE_BETWEEN) {
            maa = Alignment.MainAxis.CENTER;
        }
        int spaceCount = Math.max(amount - 1, 0);
        if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
            if (expandedAmount > 0) {
                maa = Alignment.MainAxis.START;
            } else {
                space = 0;
            }
        }
        childrenSize += space * spaceCount;
        if (expandedAmount > 0 && hasSize) {
            int newSize = (size - childrenSize) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(this.axis) || !widget.flex().isExpanded()) continue;
                widget.getArea().setSize(this.axis, newSize);
                widget.resizer().setSizeResized(this.axis, true);
            }
        }
        int lastP = padding.getStart(this.axis);
        if (hasSize) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastP += (int)((float)size / 2.0f - (float)childrenSize / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastP += size - childrenSize;
            }
        }
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(this.axis)) continue;
            Box margin = widget.getArea().getMargin();
            widget.getArea().setRelativePoint(this.axis, lastP + margin.getStart(this.axis));
            widget.resizer().setPosResized(this.axis, true);
            widget.resizer().setMarginPaddingApplied(this.axis, true);
            lastP += widget.getArea().requestedSize(this.axis) + space;
            if (!hasSize || maa != Alignment.MainAxis.SPACE_BETWEEN) continue;
            lastP += (size - childrenSize) / spaceCount;
        }
    }

    @Override
    public void postLayoutWidgets() {
        GuiAxis other = this.axis.getOther();
        int width = this.getArea().getSize(other);
        Box padding = this.getArea().getPadding();
        boolean hasWidth = this.resizer().isSizeCalculated(other);
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasPos(this.axis)) continue;
            Box margin = widget.getArea().getMargin();
            if (!widget.flex().hasPos(other) && widget.resizer().isSizeCalculated(other)) {
                int crossAxisPos = margin.getStart(other) + padding.getStart(other);
                if (hasWidth) {
                    if (this.caa == Alignment.CrossAxis.CENTER) {
                        crossAxisPos = (int)((float)width / 2.0f - (float)widget.getArea().getSize(other) / 2.0f);
                    } else if (this.caa == Alignment.CrossAxis.END) {
                        crossAxisPos = width - widget.getArea().getSize(other) - margin.getEnd(other) - padding.getStart(other);
                    }
                }
                widget.getArea().setRelativePoint(other, crossAxisPos);
                widget.getArea().setPoint(other, this.getArea().getPoint(other) + crossAxisPos);
                widget.resizer().setPosResized(other, true);
                widget.resizer().setMarginPaddingApplied(other, true);
            }
            if (!this.isValid()) continue;
            widget.flex().applyPos(widget);
        }
    }

    @Override
    public boolean shouldIgnoreChildSize(IWidget child) {
        return this.collapseDisabledChild && !child.isEnabled();
    }

    @Override
    public void onChildChangeEnabled(IWidget child, boolean enabled) {
        if (this.collapseDisabledChild) {
            ILayoutWidget.super.onChildChangeEnabled(child, enabled);
        }
    }

    public Flow crossAxisAlignment(Alignment.CrossAxis caa) {
        this.caa = caa;
        return this;
    }

    public Flow mainAxisAlignment(Alignment.MainAxis maa) {
        this.maa = maa;
        return this;
    }

    public Flow childPadding(int spaceBetween) {
        this.spaceBetween = spaceBetween;
        return this;
    }

    public Flow collapseDisabledChild() {
        this.collapseDisabledChild = true;
        return this;
    }

    public Flow collapseDisabledChild(boolean doCollapse) {
        this.collapseDisabledChild = doCollapse;
        return this;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    @Override
    public GuiAxis getExpandAxis() {
        return this.axis;
    }
}

