/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeUtils {
    public static List<BiomeGenBase> getAllowedBiomes() {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static int getDistanceToBiome(EntityPlayer player, int x, int z) {
        return (int)player.func_70011_f((double)x, player.field_70163_u, (double)z);
    }

    public static String getBiomeName(BiomeGenBase biome) {
        if (biome != null && biome.field_76791_y != null) {
            if (ConfigHandler.fixBiomeNames) {
                String original = biome.field_76791_y;
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return biome.field_76791_y;
        }
        return "";
    }

    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(BiomeGenBase.func_150568_d((int)biomeID));
    }

    public static List<String> getListBiomeTags(BiomeGenBase biome) {
        return Stream.of(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)).map(Enum::name).map(String::toLowerCase).sorted().collect(Collectors.toList());
    }

    public static String getBiomeTags(BiomeGenBase biome) {
        return Stream.of(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)).map(Enum::name).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).sorted().collect(Collectors.joining(", "));
    }

    public static String getBiomeClimate(BiomeGenBase biome) {
        if (BiomeUtils.getListBiomeTags(biome).contains("nether")) {
            return I18n.func_135052_a((String)"string.naturescompass.hellish", (Object[])new Object[0]);
        }
        if (biome.field_76750_F > 1.0f) {
            return I18n.func_135052_a((String)"string.naturescompass.hot", (Object[])new Object[0]);
        }
        if (biome.field_76750_F > 0.85f) {
            return I18n.func_135052_a((String)"string.naturescompass.warm", (Object[])new Object[0]);
        }
        if (biome.field_76750_F > 0.35f) {
            return I18n.func_135052_a((String)"string.naturescompass.normal", (Object[])new Object[0]);
        }
        if (biome.field_76750_F > 0.0f) {
            return I18n.func_135052_a((String)"string.naturescompass.cold", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"string.naturescompass.icy", (Object[])new Object[0]);
    }

    public static String getBiomeHumidity(BiomeGenBase biome) {
        if (biome.field_76751_G > 0.85f) {
            return I18n.func_135052_a((String)"string.naturescompass.damp", (Object[])new Object[0]);
        }
        if (biome.field_76751_G >= 0.3f) {
            return I18n.func_135052_a((String)"string.naturescompass.normal", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"string.naturescompass.arid", (Object[])new Object[0]);
    }

    public static boolean biomeIsBlacklisted(BiomeGenBase biome) {
        List<String> biomeBlacklist = ConfigHandler.getBiomeBlacklist();
        return biomeBlacklist.contains(String.valueOf(biome.field_76756_M)) || biomeBlacklist.contains(BiomeUtils.getBiomeName(biome)) || biomeBlacklist.contains(biome.field_76791_y);
    }
}

