/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.component;

import io.github.cruciblemc.necrotempus.api.bossbar.BossBarColor;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarType;
import java.util.Arrays;
import java.util.List;

public class BossDisplayAdapter {
    private final String targetClass;
    private final BossBarColor color;
    private final BossBarType type;
    private int lazyColor = -1;

    public BossDisplayAdapter(String targetClass, BossBarColor color, BossBarType type) {
        this.targetClass = targetClass;
        this.color = color;
        this.type = type;
        if (color == BossBarColor.LAZY) {
            this.lazyColor = color.intValue();
        }
    }

    public static List<BossDisplayAdapter> defaultList() {
        return Arrays.asList(new BossDisplayAdapter("net.minecraft.entity.boss.EntityDragon", BossBarColor.PINK, BossBarType.NOTCHED_10), new BossDisplayAdapter("net.minecraft.entity.boss.EntityWither", BossBarColor.PURPLE, BossBarType.FLAT), new BossDisplayAdapter("vazkii.botania.common.entity.EntityDoppleganger", BossBarColor.PINK, BossBarType.NONE), new BossDisplayAdapter("noppes.npcs.entity.EntityCustomNpc", BossBarColor.PINK, BossBarType.NONE));
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public BossBarColor getColor() {
        return this.color;
    }

    public BossBarType getType() {
        return this.type;
    }

    public int getLazyColor() {
        return this.lazyColor;
    }

    public void setLazyColor(int lazyColor) {
        this.lazyColor = lazyColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossDisplayAdapter)) {
            return false;
        }
        BossDisplayAdapter other = (BossDisplayAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLazyColor() != other.getLazyColor()) {
            return false;
        }
        String this$targetClass = this.getTargetClass();
        String other$targetClass = other.getTargetClass();
        if (this$targetClass == null ? other$targetClass != null : !this$targetClass.equals(other$targetClass)) {
            return false;
        }
        BossBarColor this$color = this.getColor();
        BossBarColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        BossBarType this$type = this.getType();
        BossBarType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BossDisplayAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLazyColor();
        String $targetClass = this.getTargetClass();
        result = result * 59 + ($targetClass == null ? 43 : $targetClass.hashCode());
        BossBarColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        BossBarType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "BossDisplayAdapter(targetClass=" + this.getTargetClass() + ", color=" + (Object)((Object)this.getColor()) + ", type=" + (Object)((Object)this.getType()) + ", lazyColor=" + this.getLazyColor() + ")";
    }
}

