/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.title.client.render;

import io.github.cruciblemc.necrotempus.api.title.TitleElement;
import io.github.cruciblemc.necrotempus.api.title.TitleType;
import io.github.cruciblemc.necrotempus.modules.features.title.client.ClientTitleManager;
import io.github.cruciblemc.necrotempus.modules.features.title.component.TimedTitle;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class TitleGui
extends Gui {
    private final Minecraft minecraft;
    private static TitleGui instance;

    public static TitleGui getInstance() {
        return instance != null ? instance : new TitleGui();
    }

    private TitleGui() {
        instance = this;
        this.minecraft = Minecraft.func_71410_x();
    }

    public boolean shouldRender() {
        return ClientTitleManager.getCurrentTitle() != null && TitleGui.finalTime(ClientTitleManager.getCurrentTitle()) >= System.currentTimeMillis();
    }

    public static int maxTime(TimedTitle title) {
        return title.getFadeIn() + title.getStay() + title.getFadeOut();
    }

    public static long finalTime(TimedTitle title) {
        return title.getStartTime() + (long)TitleGui.maxTime(title);
    }

    public void render(ScaledResolution resolution) {
        this.minecraft.field_71424_I.func_76320_a("necroTempusTitle");
        TimedTitle title = ClientTitleManager.getCurrentTitle();
        long elapsedTime = System.currentTimeMillis() - title.getStartTime();
        int currentState = TitleGui.getCurrentState(title, elapsedTime);
        float currentOpacity = TitleGui.getCurrentOpacity(title, elapsedTime, currentState);
        if (currentOpacity < 8.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)resolution.func_78326_a() / 2.0f), (float)((float)resolution.func_78328_b() / 2.0f), (float)0.0f);
        int color = new Color(255, 255, 255, (int)currentOpacity).getRGB();
        if (title.hasElement(TitleType.TITLE)) {
            this.renderTitle(title, color);
        }
        if (title.hasElement(TitleType.SUBTITLE)) {
            this.renderSubtitle(title, color);
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        this.minecraft.field_71424_I.func_76319_b();
    }

    private void renderSubtitle(TimedTitle title, int color) {
        this.minecraft.field_71424_I.func_76320_a("subtitle");
        TitleElement subtitleElement = title.getElement(TitleType.SUBTITLE);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        int width = -(this.minecraft.field_71466_p.func_78256_a(subtitleElement.getText().func_150254_d()) / 2);
        int height = 5;
        this.minecraft.field_71466_p.func_78261_a(subtitleElement.getText().func_150254_d(), width, height, color);
        GL11.glPopMatrix();
        this.minecraft.field_71424_I.func_76319_b();
    }

    private void renderTitle(TimedTitle title, int color) {
        this.minecraft.field_71424_I.func_76320_a("title");
        TitleElement titleElement = title.getElement(TitleType.TITLE);
        GL11.glPushMatrix();
        GL11.glScalef((float)4.0f, (float)4.0f, (float)4.0f);
        int width = -(this.minecraft.field_71466_p.func_78256_a(titleElement.getText().func_150254_d()) / 2);
        int height = -10;
        this.minecraft.field_71466_p.func_78261_a(titleElement.getText().func_150254_d(), width, height, color);
        GL11.glPopMatrix();
        this.minecraft.field_71424_I.func_76319_b();
    }

    private static float getCurrentOpacity(TimedTitle title, long elapsedTime, int currentState) {
        float f;
        switch (currentState) {
            case 0: {
                f = TitleGui.clamp((float)elapsedTime / (float)title.getFadeIn() * 255.0f);
                break;
            }
            case 2: {
                f = 255.0f - TitleGui.clamp((float)(elapsedTime - (long)(title.getFadeIn() + title.getStay())) / (float)title.getFadeOut() * 255.0f);
                break;
            }
            default: {
                f = 255.0f;
            }
        }
        return f;
    }

    private static int getCurrentState(TimedTitle title, long elapsedTime) {
        return elapsedTime <= (long)title.getFadeIn() ? 0 : (elapsedTime <= (long)(title.getFadeIn() + title.getStay()) ? 1 : 2);
    }

    private static float clamp(float value) {
        return Math.max(0.0f, Math.min(255.0f, value));
    }
}

