/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelGeneratorClassic;
import greymerk.roguelike.dungeon.LevelGeneratorMST;
import greymerk.roguelike.dungeon.rooms.DungeonLinker;
import greymerk.roguelike.dungeon.rooms.DungeonLinkerTop;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Random;

public enum LevelGenerator {
    CLASSIC,
    MST;


    public static ILevelGenerator getGenerator(IWorldEditor editor, Random rand, LevelGenerator type, IDungeonLevel level) {
        switch (type) {
            case CLASSIC: {
                return new LevelGeneratorClassic(editor, rand, level);
            }
            case MST: {
                return new LevelGeneratorMST(editor, rand, level);
            }
        }
        return new LevelGeneratorClassic(editor, rand, level);
    }

    public static void generateLevelLink(IWorldEditor editor, Random rand, LevelSettings settings, Coord start, DungeonNode oldEnd) {
        DungeonLinker downstairs = new DungeonLinker();
        downstairs.generate(editor, rand, settings, Cardinal.directions, start);
        if (oldEnd == null) {
            return;
        }
        DungeonLinkerTop upstairs = new DungeonLinkerTop();
        upstairs.generate(editor, rand, settings, oldEnd.getEntrances(), oldEnd.getPosition());
        IStair stair = settings.getTheme().getPrimaryStair();
        Coord cursor = new Coord(start);
        for (int i = 0; i < oldEnd.getPosition().getY() - start.getY(); ++i) {
            editor.spiralStairStep(rand, cursor, stair, settings.getTheme().getPrimaryPillar());
            cursor.add(Cardinal.UP);
        }
    }
}

